/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.jtransforms.fft.FloatingPointEqualityChecker;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class FloatFFT_1DTest {
    public static final String DEFAULT_MESSAGE = "%d-threaded FFT of size %d: ";
    private static final String FFTW_INPUT_PATTERN = "fftw%d.in";
    private static final String FFTW_OUTPUT_PATTERN = "fftw%d.out";
    public static final int SEED = 20110625;
    private final FloatFFT_1D fft;
    private final int n;
    private final Random random;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        int[] nArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65530, 65536, 131072};
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(new Object[]{nArray[i], 1, 20110625});
            arrayList.add(new Object[]{nArray[i], 2, 20110625});
            arrayList.add(new Object[]{nArray[i], 4, 20110625});
        }
        return arrayList;
    }

    public FloatFFT_1DTest(int n, int n2, long l) {
        this.n = n;
        this.fft = new FloatFFT_1D(n);
        this.random = new Random(l);
        ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(512);
        ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(512);
        ConcurrencyUtils.setNumberOfThreads(n2);
    }

    public FloatingPointEqualityChecker createEqualityChecker(float f, float f2) {
        String string = String.format(DEFAULT_MESSAGE, ConcurrencyUtils.getNumberOfThreads(), this.n);
        return new FloatingPointEqualityChecker(string, 0.0, 0.0, f, f2);
    }

    public void readData(String string, double[] dArray) {
        try {
            File file = new File(this.getClass().getClassLoader().getResource(string).getFile());
            FileInputStream fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(8 * dArray.length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            fileChannel.read(byteBuffer);
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = byteBuffer.getDouble(8 * i);
            }
        }
        catch (IOException iOException) {
            Assert.fail((String)iOException.getMessage());
        }
    }

    @Test
    public void testComplexForward() {
        int n;
        float f = 0.001f;
        float f2 = 0.05f;
        if (this.n == 65530 || this.n == 131072) {
            f = 0.005f;
        }
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[] fArray = new float[2 * this.n];
        double[] dArray = new double[2 * this.n];
        this.readData(String.format(FFTW_INPUT_PATTERN, this.n), dArray);
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = (float)dArray[n];
        }
        this.readData(String.format(FFTW_OUTPUT_PATTERN, this.n), dArray);
        this.fft.complexForward(fArray);
        for (n = 0; n < fArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", (float)dArray[n], fArray[n]);
        }
    }

    @Test
    public void testComplexInverseScaled() {
        int n;
        float f = 5.0E-4f;
        float f2 = 0.005f;
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[] fArray = new float[2 * this.n];
        float[] fArray2 = new float[2 * this.n];
        for (n = 0; n < 2 * this.n; ++n) {
            fArray[n] = (float)(2.0 * this.random.nextDouble() - 1.0);
            fArray2[n] = fArray[n];
        }
        this.fft.complexForward(fArray);
        this.fft.complexInverse(fArray, true);
        for (n = 0; n < fArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", fArray2[n], fArray[n]);
        }
    }

    @Test
    public void testComplexInverseUnscaled() {
        float f = 5.0E-4f;
        float f2 = 0.005f;
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[] fArray = new float[2 * this.n];
        float[] fArray2 = new float[2 * this.n];
        for (int i = 0; i < 2 * this.n; ++i) {
            fArray[i] = (float)(2.0 * this.random.nextDouble() - 1.0);
            fArray2[i] = fArray[i];
        }
        this.fft.complexForward(fArray);
        this.fft.complexInverse(fArray, false);
        float f4 = 1.0f / (float)this.n;
        for (int i = 0; i < fArray.length; ++i) {
            floatingPointEqualityChecker.assertEquals("[" + i + "]", fArray2[i], f4 * fArray[i]);
        }
    }

    @Test
    public void testRealForward() {
        int n;
        float f = 5.0E-4f;
        float f2 = 0.005f;
        if (this.n == 16384) {
            f = 0.002f;
        }
        if (this.n == 32768) {
            f = 0.005f;
            f2 = 0.01f;
        }
        if (this.n == 65536) {
            f = 0.01f;
            f2 = 0.01f;
        }
        if (this.n == 131072) {
            f = 0.01f;
            f2 = 0.01f;
        }
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[] fArray = new float[this.n];
        float[] fArray2 = new float[2 * this.n];
        for (n = 0; n < this.n; ++n) {
            fArray[n] = (float)(2.0 * this.random.nextDouble() - 1.0);
            fArray2[2 * n] = fArray[n];
            fArray2[2 * n + 1] = 0.0f;
        }
        this.fft.complexForward(fArray2);
        this.fft.realForward(fArray);
        floatingPointEqualityChecker.assertEquals("[0]", fArray2[0], fArray[0]);
        if (this.n > 1) {
            floatingPointEqualityChecker.assertEquals("[1]", fArray2[this.n], fArray[1]);
        }
        for (n = 2; n < fArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", fArray2[n], fArray[n]);
        }
    }

    @Test
    public void testRealForwardFull() {
        int n;
        float f = 5.0E-4f;
        float f2 = 0.005f;
        if (this.n == 8192) {
            f = 0.005f;
        }
        if (this.n == 16384) {
            f = 0.005f;
        }
        if (this.n == 32768) {
            f = 0.005f;
            f2 = 0.01f;
        }
        if (this.n == 65536) {
            f = 0.01f;
            f2 = 0.01f;
        }
        if (this.n == 131072) {
            f = 0.01f;
        }
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[] fArray = new float[2 * this.n];
        float[] fArray2 = new float[2 * this.n];
        for (n = 0; n < this.n; ++n) {
            fArray[n] = (float)(2.0 * this.random.nextDouble() - 1.0);
            fArray2[2 * n] = fArray[n];
            fArray2[2 * n + 1] = 0.0f;
        }
        this.fft.complexForward(fArray2);
        this.fft.realForwardFull(fArray);
        for (n = 0; n < fArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", fArray2[n], fArray[n]);
        }
    }

    @Test
    public void testRealInverseFullScaled() {
        int n;
        float f = 5.0E-4f;
        float f2 = 0.001f;
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[] fArray = new float[2 * this.n];
        float[] fArray2 = new float[2 * this.n];
        for (n = 0; n < this.n; ++n) {
            fArray[n] = (float)(2.0 * this.random.nextDouble() - 1.0);
            fArray2[2 * n] = fArray[n];
            fArray2[2 * n + 1] = 0.0f;
        }
        this.fft.realInverseFull(fArray, true);
        this.fft.complexInverse(fArray2, true);
        for (n = 0; n < fArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", fArray2[n], fArray[n]);
        }
    }

    @Test
    public void testRealInverseFullUnscaled() {
        int n;
        float f = 0.005f;
        float f2 = 0.001f;
        if (this.n == 32768) {
            f = 0.01f;
            f2 = 0.005f;
        }
        if (this.n == 65536) {
            f = 0.01f;
            f2 = 0.01f;
        }
        if (this.n == 131072) {
            f = 0.01f;
            f2 = 0.005f;
        }
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[] fArray = new float[2 * this.n];
        float[] fArray2 = new float[2 * this.n];
        for (n = 0; n < this.n; ++n) {
            fArray[n] = (float)(2.0 * this.random.nextDouble() - 1.0);
            fArray2[2 * n] = fArray[n];
            fArray2[2 * n + 1] = 0.0f;
        }
        this.fft.realInverseFull(fArray, false);
        this.fft.complexInverse(fArray2, false);
        for (n = 0; n < fArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", fArray2[n], fArray[n]);
        }
    }

    @Test
    public void testRealInverseScaled() {
        int n;
        float f = 0.005f;
        float f2 = 0.001f;
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[] fArray = new float[this.n];
        float[] fArray2 = new float[this.n];
        for (n = 0; n < this.n; ++n) {
            fArray[n] = (float)(2.0 * this.random.nextDouble() - 1.0);
            fArray2[n] = fArray[n];
        }
        this.fft.realForward(fArray);
        this.fft.realInverse(fArray, true);
        for (n = 0; n < fArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", fArray2[n], fArray[n]);
        }
    }

    @Test
    public void testRealInverseUnscaled() {
        int n;
        float f = 0.005f;
        float f2 = 0.001f;
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[] fArray = new float[this.n];
        float[] fArray2 = new float[this.n];
        for (n = 0; n < this.n; ++n) {
            fArray[n] = (float)(2.0 * this.random.nextDouble() - 1.0);
            fArray2[n] = fArray[n];
        }
        this.fft.realForward(fArray);
        this.fft.realInverse(fArray, true);
        for (n = 0; n < fArray.length; ++n) {
            floatingPointEqualityChecker.assertEquals("[" + n + "]", fArray2[n], fArray[n]);
        }
    }
}

