/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.Interval;
import edu.unc.genomics.IntervalFactory;
import edu.unc.genomics.io.StringIntervalIterator;
import java.util.Iterator;

public class SelectiveStringIntervalIterator<T extends Interval>
extends StringIntervalIterator<T> {
    private T nextInterval;
    private final String chr;
    private final int start;
    private final int stop;

    public SelectiveStringIntervalIterator(Iterator<String> it, IntervalFactory<T> factory, String chr, int start, int stop) {
        super(it, factory);
        this.chr = chr;
        this.start = start;
        this.stop = stop;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.nextInterval != null;
    }

    @Override
    public T next() {
        T temp = this.nextInterval;
        this.advance();
        return temp;
    }

    private void advance() {
        this.nextInterval = null;
        while (this.nextInterval == null && this.it.hasNext()) {
            String line = (String)this.it.next();
            Object interval = this.factory.parse(line);
            if (interval == null || !((Interval)interval).getChr().equals(this.chr) || ((Interval)interval).getStop() < this.start || ((Interval)interval).getStart() > this.stop) continue;
            this.nextInterval = interval;
        }
    }
}

