/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.RuntimeIOException;

public class SortingLongCollection {
    public static final int SIZEOF = 8;
    public static final int MAX_ITEMS_IN_RAM = (int)Math.floor(2.68167019545E8);
    private final File[] tmpDir;
    private final int maxValuesInRam;
    private int numValuesInRam = 0;
    private long[] ramValues;
    private boolean doneAdding = false;
    private boolean cleanedUp = false;
    private final List<File> files = new ArrayList<File>();
    private int iterationIndex = 0;
    private PriorityQueue<PeekFileValueIterator> priorityQueue;

    public SortingLongCollection(int maxValuesInRam, File ... tmpDir) {
        if (maxValuesInRam <= 0) {
            throw new IllegalArgumentException("maxValuesInRam must be > 0");
        }
        this.tmpDir = tmpDir;
        this.maxValuesInRam = Math.min(maxValuesInRam, MAX_ITEMS_IN_RAM);
        this.ramValues = new long[maxValuesInRam];
    }

    public void add(long value) {
        if (this.doneAdding) {
            throw new IllegalStateException("Cannot add after calling doneAddingStartIteration()");
        }
        if (this.numValuesInRam == this.maxValuesInRam) {
            this.spillToDisk();
        }
        this.ramValues[this.numValuesInRam++] = value;
    }

    public void doneAddingStartIteration() {
        if (this.cleanedUp || this.doneAdding) {
            throw new IllegalStateException("Cannot call doneAddingStartIteration() after cleanup() was called.");
        }
        this.doneAdding = true;
        if (this.files.isEmpty()) {
            Arrays.sort(this.ramValues, 0, this.numValuesInRam);
            return;
        }
        if (this.numValuesInRam > 0) {
            this.spillToDisk();
        }
        this.priorityQueue = new PriorityQueue<PeekFileValueIterator>(this.files.size(), new PeekFileValueIteratorComparator());
        for (File f : this.files) {
            FileValueIterator it = new FileValueIterator(f);
            if (!it.hasNext()) continue;
            this.priorityQueue.offer(new PeekFileValueIterator(it));
        }
        this.ramValues = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spillToDisk() {
        try {
            Arrays.sort(this.ramValues, 0, this.numValuesInRam);
            File f = IOUtil.newTempFile("sortingcollection.", ".tmp", this.tmpDir, 0x140000000L);
            RandomAccessFile os = null;
            try {
                long numBytes = this.numValuesInRam * 8;
                os = new RandomAccessFile(f, "rw");
                f.deleteOnExit();
                FileChannel channel = os.getChannel();
                MappedByteBuffer byteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, numBytes);
                LongBuffer longBuffer = byteBuffer.asLongBuffer();
                longBuffer.put(this.ramValues, 0, this.numValuesInRam);
                byteBuffer.force();
                channel.close();
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
            this.numValuesInRam = 0;
            this.files.add(f);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void cleanup() {
        this.doneAdding = true;
        this.cleanedUp = true;
        this.ramValues = null;
        IOUtil.deleteFiles(this.files);
    }

    public boolean hasNext() {
        if (!this.doneAdding || this.cleanedUp) {
            throw new IllegalStateException();
        }
        if (this.ramValues != null) {
            return this.iterationIndex < this.numValuesInRam;
        }
        return !this.priorityQueue.isEmpty();
    }

    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.ramValues != null) {
            return this.ramValues[this.iterationIndex++];
        }
        PeekFileValueIterator fileIterator = this.priorityQueue.poll();
        long ret = fileIterator.next();
        if (fileIterator.hasNext()) {
            this.priorityQueue.offer(fileIterator);
        } else {
            fileIterator.close();
        }
        return ret;
    }

    private static class PeekFileValueIteratorComparator
    implements Comparator<PeekFileValueIterator> {
        private PeekFileValueIteratorComparator() {
        }

        @Override
        public int compare(PeekFileValueIterator it1, PeekFileValueIterator it2) {
            if (it1.peek() < it2.peek()) {
                return -1;
            }
            if (it1.peek() == it2.peek()) {
                return 0;
            }
            return 1;
        }
    }

    private static class PeekFileValueIterator {
        private FileValueIterator underlyingIterator;
        private long peekValue;
        private boolean hasPeekedValue = false;

        PeekFileValueIterator(FileValueIterator underlyingIterator) {
            this.underlyingIterator = underlyingIterator;
        }

        boolean hasNext() {
            return this.hasPeekedValue || this.underlyingIterator.hasNext();
        }

        long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.hasPeekedValue) {
                this.hasPeekedValue = false;
                return this.peekValue;
            }
            return this.underlyingIterator.next();
        }

        long peek() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.hasPeekedValue) {
                this.peekValue = this.underlyingIterator.next();
                this.hasPeekedValue = true;
            }
            return this.peekValue;
        }

        void close() {
            this.underlyingIterator.close();
            this.hasPeekedValue = false;
            this.underlyingIterator = null;
        }
    }

    private static class FileValueIterator {
        private final File file;
        private LongBuffer longBuffer;

        FileValueIterator(File file) {
            this.file = file;
            try {
                FileInputStream is = new FileInputStream(file);
                FileChannel channel = is.getChannel();
                this.longBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size()).asLongBuffer();
                channel.close();
                is.close();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException(file.getAbsolutePath(), e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        boolean hasNext() {
            return this.longBuffer.hasRemaining();
        }

        long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.longBuffer.get();
        }

        void close() {
            IOUtil.deleteFiles(this.file);
            this.longBuffer = null;
        }
    }
}

