/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.Interval;
import edu.unc.genomics.IntervalFactory;
import edu.unc.genomics.io.BufferedLineReader;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.StringIntervalIterator;
import edu.unc.genomics.util.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class TextIntervalFile<T extends Interval>
extends IntervalFile<T> {
    private static final Logger log = Logger.getLogger(TextIntervalFile.class);
    protected IntervalFactory<T> factory;
    private Set<String> chromosomes;
    private int count = 0;
    private final BufferedReader reader;
    private final Iterator<T> iter;

    protected TextIntervalFile(Path p, IntervalFactory<T> factory) throws IOException {
        super(p);
        this.factory = factory;
        this.reader = Files.newBufferedReader(p, Charset.defaultCharset());
        BufferedLineReader lineReader = new BufferedLineReader(this.reader);
        this.iter = new StringIntervalIterator<T>(lineReader.iterator(), factory);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public Set<String> chromosomes() {
        if (this.chromosomes == null) {
            this.chromosomes = new HashSet<String>();
            this.count = 0;
            for (Interval i : this) {
                this.chromosomes.add(i.getChr());
                ++this.count;
            }
        }
        return this.chromosomes;
    }

    @Override
    public int count() {
        if (this.count == 0) {
            try {
                this.count = FileUtils.countLines(this.p);
            }
            catch (IOException e) {
                log.error((Object)("Error counting lines in file: " + this.p));
                e.printStackTrace();
            }
        }
        return this.count;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iter;
    }

    @Override
    public Iterator<T> query(String chr, int start, int stop) {
        throw new UnsupportedOperationException("Cannot randomly query unindexed TextIntervalFiles");
    }
}

