/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.math.stat.Frequency;
import org.apache.log4j.Logger;

public class IntervalLengthDistribution
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(IntervalLengthDistribution.class);
    @Parameter(names={"-i", "--input"}, description="Interval file", required=true)
    public IntervalFile<? extends Interval> inputFile;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        int n;
        Object object2;
        log.debug((Object)"Generating histogram of interval lengths");
        Frequency frequency = new Frequency();
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        for (Object object2 : this.inputFile) {
            n = object2.length();
            frequency.addValue(n);
            if (n < n2) {
                n2 = n;
            }
            if (n <= n3) continue;
            n3 = n;
        }
        log.debug((Object)"Writing histogram output");
        BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);
        object2 = null;
        try {
            for (n = n2; n <= n3; ++n) {
                bufferedWriter.write(n + "\t" + frequency.getCount(n));
                bufferedWriter.newLine();
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (bufferedWriter != null) {
                if (object2 != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    bufferedWriter.close();
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        new IntervalLengthDistribution().instanceMain(stringArray);
    }
}

