/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Scale
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Scale.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    @Parameter(names={"-m", "--multiplier"}, description="Multiplier (scale factor, default = 1/mean)")
    public Double multiplier;

    @Override
    public void setup() {
        this.inputs.add(this.inputFile);
        if (this.multiplier == null || this.multiplier == 0.0) {
            this.multiplier = (double)this.inputFile.numBases() / this.inputFile.total();
        }
    }

    @Override
    public float[] compute(String string, int n, int n2) throws IOException, WigFileException {
        log.debug((Object)("Computing difference for chunk " + string + ":" + n + "-" + n2));
        Iterator iterator = this.inputFile.query(string, n, n2);
        float[] fArray = WigFile.flattenData((Iterator)iterator, (int)n, (int)n2);
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)(this.multiplier * (double)fArray[i]);
        }
        return fArray;
    }

    public static void main(String[] stringArray) throws IOException, WigFileException {
        new Scale().instanceMain(stringArray);
    }
}

