/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.SubmittedJob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public class JobQueue
implements ListModel<SubmittedJob>,
Iterable<SubmittedJob> {
    private static final Logger log = Logger.getLogger(JobQueue.class);
    private final List<SubmittedJob> submittedJobs = new ArrayList<SubmittedJob>();
    private final List<ListDataListener> dataListeners = new ArrayList<ListDataListener>();

    public void add(SubmittedJob submittedJob) {
        int n = this.submittedJobs.size();
        this.submittedJobs.add(submittedJob);
        ListDataEvent listDataEvent = new ListDataEvent(this, 1, n, n);
        for (ListDataListener listDataListener : this.dataListeners) {
            listDataListener.intervalAdded(listDataEvent);
        }
    }

    public void remove(SubmittedJob submittedJob) {
        this.submittedJobs.remove(submittedJob);
        int n = this.submittedJobs.size();
        ListDataEvent listDataEvent = new ListDataEvent(this, 2, n, n);
        for (ListDataListener listDataListener : this.dataListeners) {
            listDataListener.intervalAdded(listDataEvent);
        }
    }

    public void update(SubmittedJob submittedJob) {
        int n = this.submittedJobs.indexOf(submittedJob);
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, n, n);
        for (ListDataListener listDataListener : this.dataListeners) {
            listDataListener.intervalAdded(listDataEvent);
        }
    }

    @Override
    public int getSize() {
        return this.submittedJobs.size();
    }

    @Override
    public SubmittedJob getElementAt(int n) {
        return this.submittedJobs.get(n);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.dataListeners.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.dataListeners.remove(listDataListener);
    }

    @Override
    public Iterator<SubmittedJob> iterator() {
        return this.submittedJobs.iterator();
    }
}

