/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class Autocorrelation
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(Autocorrelation.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile wig;
    @Parameter(names={"-l", "--loci"}, description="Genomic loci (Bed format)", required=true)
    public IntervalFile<? extends Interval> loci;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    @Parameter(names={"-m", "--max"}, description="Autocorrelation limit (bp)")
    public int limit = 200;

    private void abs2(float[] fArray) {
        for (int i = 0; i < fArray.length; i += 2) {
            fArray[i] = fArray[i] * fArray[i] + fArray[i + 1] * fArray[i + 1];
            fArray[i + 1] = 0.0f;
        }
    }

    @Override
    public void run() throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            log.debug((Object)"Computing autocorrelation for each window");
            int n = 0;
            for (Interval interval : this.loci) {
                Iterator iterator;
                if (interval.length() < this.limit) {
                    log.debug((Object)("Skipping interval: " + interval.toString()));
                    ++n;
                    continue;
                }
                try {
                    iterator = this.wig.query(interval);
                }
                catch (WigFileException | IOException throwable) {
                    log.debug((Object)("Skipping interval: " + interval.toString()));
                    ++n;
                    continue;
                }
                float[] fArray = WigFile.flattenData((Iterator)iterator, (int)interval.getStart(), (int)interval.getStop());
                FloatFFT_1D floatFFT_1D = new FloatFFT_1D(fArray.length);
                floatFFT_1D.realForward(fArray);
                this.abs2(fArray);
                floatFFT_1D.realInverse(fArray, true);
                bufferedWriter.write(StringUtils.join((Object[])new Serializable[]{fArray, "\t"}));
                bufferedWriter.newLine();
            }
            log.info((Object)("Skipped " + n + " intervals"));
        }
    }

    public static void main(String[] stringArray) {
        new Autocorrelation().instanceMain(stringArray);
    }
}

