/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.nucleosomes.NucleosomeCall;
import edu.unc.genomics.nucleosomes.NucleosomeCallsFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NRLCalculator
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(NRLCalculator.class);
    @Parameter(names={"-i", "--input"}, description="Input file (nucleosome calls)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-l", "--loci"}, description="Genomic loci (Bed format)", required=true)
    public IntervalFile<? extends Interval> lociFile;
    @Parameter(names={"-o", "--output"}, description="Output file (NRL for each gene)", required=true)
    public Path outputFile;
    private Map<String, List<NucleosomeCall>> nucs = new HashMap<String, List<NucleosomeCall>>();

    private List<NucleosomeCall> getIntervalNucleosomes(Interval interval) {
        ArrayList<NucleosomeCall> arrayList = new ArrayList<NucleosomeCall>();
        for (NucleosomeCall nucleosomeCall : this.nucs.get(interval.getChr())) {
            if (nucleosomeCall.getDyad() < interval.low() || nucleosomeCall.getDyad() > interval.high()) continue;
            arrayList.add(nucleosomeCall);
        }
        return arrayList;
    }

    @Override
    public void run() throws IOException {
        Object object;
        log.debug((Object)"Initializing input file");
        NucleosomeCallsFile nucleosomeCallsFile = new NucleosomeCallsFile(this.inputFile);
        log.debug((Object)"Loading all nucleosomes");
        Object object2 = nucleosomeCallsFile.iterator();
        while (object2.hasNext()) {
            object = (NucleosomeCall)object2.next();
            if (object == null) continue;
            if (!this.nucs.containsKey(object.getChr())) {
                this.nucs.put(object.getChr(), new ArrayList());
            }
            this.nucs.get(object.getChr()).add((NucleosomeCall)object);
        }
        nucleosomeCallsFile.close();
        log.debug((Object)"Initializing output file");
        object2 = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);
        object = null;
        try {
            log.debug((Object)"Calculating nucleosome spacing for each interval");
            NucleosomeCall.DyadComparator dyadComparator = new NucleosomeCall.DyadComparator();
            for (Interval interval : this.lociFile) {
                ((Writer)object2).write(interval.toBed());
                List<NucleosomeCall> list = this.getIntervalNucleosomes(interval);
                if (list.size() > 1) {
                    Collections.sort(list, dyadComparator);
                    if (interval.isCrick()) {
                        Collections.reverse(list);
                    }
                    for (int i = 1; i < Math.min(list.size(), 10); ++i) {
                        ((Writer)object2).write("\t" + Math.abs(list.get(i).getDyad() - list.get(i - 1).getDyad()));
                    }
                }
                ((BufferedWriter)object2).newLine();
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (object2 != null) {
                if (object != null) {
                    try {
                        ((BufferedWriter)object2).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((BufferedWriter)object2).close();
                }
            }
        }
        this.lociFile.close();
    }

    public static void main(String[] stringArray) throws IOException {
        new NRLCalculator().instanceMain(stringArray);
    }
}

