/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import edu.unc.genomics.ValuedInterval;
import edu.unc.genomics.io.IntervalFileFormatException;
import java.util.Comparator;

public class NucleosomeCall
extends ValuedInterval
implements Comparable<NucleosomeCall> {
    private static final long serialVersionUID = 6522702303121259979L;
    private int dyad;
    private double dyadStdev;
    private double dyadMean;
    private double conditionalPosition;
    private int length;
    private double lengthStdev;

    public NucleosomeCall(String string, int n, int n2) {
        super(string, n, n2);
    }

    public static NucleosomeCall parse(String string) {
        if (string.startsWith("#")) {
            return null;
        }
        String[] stringArray = string.split("\t");
        if (stringArray.length < 10) {
            throw new IntervalFileFormatException("Invalid nucleosome call has < 10 columns");
        }
        String string2 = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        NucleosomeCall nucleosomeCall = new NucleosomeCall(string2, n, n2);
        nucleosomeCall.setLength(Integer.parseInt(stringArray[3]));
        nucleosomeCall.setLengthStdev(Double.parseDouble(stringArray[4]));
        nucleosomeCall.setDyad(Integer.parseInt(stringArray[5]));
        nucleosomeCall.setDyadStdev(Double.parseDouble(stringArray[6]));
        nucleosomeCall.setConditionalPosition(Double.parseDouble(stringArray[7]));
        nucleosomeCall.setDyadMean(Double.parseDouble(stringArray[8]));
        nucleosomeCall.setValue(Double.parseDouble(stringArray[9]));
        return nucleosomeCall;
    }

    public String toString() {
        return this.chr + "\t" + this.start + "\t" + this.stop + "\t" + this.length() + "\t" + this.lengthStdev + "\t" + this.dyad + "\t" + this.dyadStdev + "\t" + this.conditionalPosition + "\t" + this.dyadMean + "\t" + this.occupancy();
    }

    public int getDyad() {
        return this.dyad;
    }

    public void setDyad(int n) {
        this.dyad = n;
    }

    public double getDyadStdev() {
        return this.dyadStdev;
    }

    public void setDyadStdev(double d) {
        this.dyadStdev = d;
    }

    public double getDyadMean() {
        return this.dyadMean;
    }

    public void setDyadMean(double d) {
        this.dyadMean = d;
    }

    public double getConditionalPosition() {
        return this.conditionalPosition;
    }

    public void setConditionalPosition(double d) {
        this.conditionalPosition = d;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public double getLengthStdev() {
        return this.lengthStdev;
    }

    public void setLengthStdev(double d) {
        this.lengthStdev = d;
    }

    public double occupancy() {
        return this.value;
    }

    public void setOccupancy(double d) {
        this.value = d;
    }

    @Override
    public int compareTo(NucleosomeCall nucleosomeCall) {
        DyadComparator dyadComparator = new DyadComparator();
        return dyadComparator.compare(this, nucleosomeCall);
    }

    public static class DyadComparator
    implements Comparator<NucleosomeCall> {
        @Override
        public int compare(NucleosomeCall nucleosomeCall, NucleosomeCall nucleosomeCall2) {
            if (nucleosomeCall.getDyad() == nucleosomeCall2.getDyad()) {
                return 0;
            }
            if (nucleosomeCall.getDyad() < nucleosomeCall2.getDyad()) {
                return -1;
            }
            return 1;
        }
    }
}

