/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class GaussianSmooth
extends WigMathTool {
    private static final Logger log = Logger.getLogger(GaussianSmooth.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    @Parameter(names={"-s", "--stdev"}, description="Standard deviation of Gaussian (bp)")
    public int stdev = 20;
    float[] filter;

    @Override
    public void setup() {
        int n;
        this.inputs.add(this.inputFile);
        this.filter = new float[6 * this.stdev + 1];
        float f = 0.0f;
        for (n = 0; n < this.filter.length; ++n) {
            float f2;
            float f3 = n - 3 * this.stdev;
            this.filter[n] = f2 = (float)Math.exp(-(f3 * f3) / (float)(2 * this.stdev * this.stdev));
            f += f2;
        }
        n = 0;
        while (n < this.filter.length) {
            int n2 = n++;
            this.filter[n2] = this.filter[n2] / f;
        }
    }

    @Override
    public float[] compute(String string, int n, int n2) throws IOException, WigFileException {
        log.debug((Object)("Smoothing chunk " + string + ":" + n + "-" + n2));
        int n3 = Math.max(n - 3 * this.stdev, this.inputFile.getChrStart(string));
        int n4 = Math.min(n2 + 3 * this.stdev, this.inputFile.getChrStop(string));
        Iterator iterator = this.inputFile.query(string, n3, n4);
        float[] fArray = WigFile.flattenData((Iterator)iterator, (int)(n - 3 * this.stdev), (int)(n2 + 3 * this.stdev));
        float[] fArray2 = new float[n2 - n + 1];
        for (int i = 0; i < fArray2.length; ++i) {
            for (int j = 0; j < this.filter.length; ++j) {
                int n5 = i;
                fArray2[n5] = fArray2[n5] + fArray[i + j] * this.filter[j];
            }
        }
        return fArray2;
    }

    public static void main(String[] stringArray) throws IOException, WigFileException {
        new GaussianSmooth().instanceMain(stringArray);
    }
}

