/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.log4j.Logger;

public class MovingAverageSmooth
extends WigMathTool {
    private static final Logger log = Logger.getLogger(MovingAverageSmooth.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    @Parameter(names={"-w", "--width"}, description="Width of kernel (bp)")
    public int width = 10;
    WigFile input;
    DescriptiveStatistics stats;

    @Override
    public void setup() {
        this.inputs.add(this.inputFile);
        log.debug((Object)"Initializing statistics");
        this.stats = new DescriptiveStatistics();
        this.stats.setWindowSize(this.width);
    }

    @Override
    public float[] compute(String string, int n, int n2) throws IOException, WigFileException {
        log.debug((Object)("Smoothing chunk " + string + ":" + n + "-" + n2));
        int n3 = Math.max(n - this.width / 2, this.input.getChrStart(string));
        int n4 = Math.min(n2 + this.width / 2, this.input.getChrStop(string));
        Iterator iterator = this.input.query(string, n3, n4);
        float[] fArray = WigFile.flattenData((Iterator)iterator, (int)n3, (int)n4);
        float[] fArray2 = new float[n2 - n + 1];
        for (int i = n; i <= n2; ++i) {
            this.stats.addValue((double)fArray[i - n3]);
            if (i - n - this.width / 2 < 0) continue;
            fArray2[i - n - this.width / 2] = (float)this.stats.getMean();
        }
        return fArray2;
    }

    public static void main(String[] stringArray) throws IOException, WigFileException {
        new MovingAverageSmooth().instanceMain(stringArray);
    }
}

