/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class WigMathTool
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(WigMathTool.class);
    public static final int DEFAULT_CHUNK_SIZE = 500000;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    protected List<WigFile> inputs = new ArrayList<WigFile>();

    public void addInputFile(WigFile wigFile) {
        this.inputs.add(wigFile);
    }

    public abstract void setup();

    public abstract float[] compute(String var1, int var2, int var3) throws IOException, WigFileException;

    @Override
    public void run() throws IOException {
        log.debug((Object)"Executing setup operations");
        this.setup();
        log.debug((Object)"Processing files and writing result to disk");
        Throwable throwable = null;
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            bufferedWriter.write("track type=wiggle_0");
            bufferedWriter.newLine();
            Set<String> set = this.getCommonChromosomes(this.inputs);
            log.debug((Object)("Found " + set.size() + " chromosomes in common between all inputs"));
            for (String string : set) {
                int n = this.getMaxChrStart(this.inputs, string);
                int n2 = this.getMinChrStop(this.inputs, string);
                log.debug((Object)("Processing chromosome " + string + " region " + n + "-" + n2));
                bufferedWriter.write("fixedStep chrom=" + string + " start=" + n + " step=1 span=1");
                bufferedWriter.newLine();
                int n3 = n;
                while (n3 < n2) {
                    int n4 = n3;
                    int n5 = Math.min(n3 + 500000 - 1, n2);
                    int n6 = n5 - n4 + 1;
                    log.debug((Object)("Processing chunk " + string + ":" + n4 + "-" + n5));
                    float[] fArray = null;
                    try {
                        fArray = this.compute(string, n4, n5);
                    }
                    catch (WigFileException wigFileException) {
                        log.fatal((Object)("Wig file error while processing chunk " + string + " region " + n + "-" + n2));
                        wigFileException.printStackTrace();
                        throw new RuntimeException("Wig file error while processing chunk " + string + " region " + n + "-" + n2);
                    }
                    if (fArray.length != n6) {
                        log.error((Object)("Expected result length=" + n6 + ", got=" + fArray.length));
                        throw new RuntimeException("Result is not the expected length!");
                    }
                    for (int i = 0; i < fArray.length; ++i) {
                        bufferedWriter.write(Float.toString(fArray[i]));
                        bufferedWriter.newLine();
                    }
                    n3 = n5 + 1;
                }
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (WigFile wigFile : this.inputs) {
            wigFile.close();
        }
    }

    public int getMaxChrStart(List<WigFile> list, String string) {
        int n = -1;
        for (WigFile wigFile : list) {
            if (wigFile.getChrStart(string) <= n) continue;
            n = wigFile.getChrStart(string);
        }
        return n;
    }

    public int getMinChrStop(List<WigFile> list, String string) {
        if (list.size() == 0) {
            return -1;
        }
        int n = Integer.MAX_VALUE;
        for (WigFile wigFile : list) {
            if (wigFile.getChrStop(string) >= n) continue;
            n = wigFile.getChrStop(string);
        }
        return n;
    }

    public Set<String> getCommonChromosomes(List<WigFile> list) {
        if (list.size() == 0) {
            return new HashSet<String>();
        }
        Set set = list.get(0).chromosomes();
        Iterator iterator = set.iterator();
        block0: while (iterator.hasNext()) {
            String string = (String)iterator.next();
            for (WigFile wigFile : list) {
                if (wigFile.includes(string)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return set;
    }
}

