/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordComparator;
import net.sf.samtools.SAMRecordCoordinateComparator;
import net.sf.samtools.SAMRecordQueryNameComparator;

public class SAMSortOrderChecker {
    private final SAMFileHeader.SortOrder sortOrder;
    private SAMRecord prev;
    private final SAMRecordComparator comparator;

    public SAMSortOrderChecker(SAMFileHeader.SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        switch (sortOrder) {
            case coordinate: {
                this.comparator = new SAMRecordCoordinateComparator();
                break;
            }
            case queryname: {
                this.comparator = new SAMRecordQueryNameComparator();
                break;
            }
            default: {
                this.comparator = null;
            }
        }
    }

    public boolean isSorted(SAMRecord rec) {
        if (this.comparator == null) {
            return true;
        }
        boolean ret = true;
        if (this.prev != null) {
            ret = this.comparator.fileOrderCompare(this.prev, rec) <= 0;
        }
        this.prev = rec;
        return ret;
    }

    public SAMRecord getPreviousRecord() {
        return this.prev;
    }

    public String getSortKey(SAMRecord rec) {
        switch (this.sortOrder) {
            case coordinate: {
                return rec.getReferenceName() + ":" + rec.getAlignmentStart();
            }
            case queryname: {
                return rec.getReadName();
            }
        }
        return null;
    }
}

