/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.Interval;

public class ValuedInterval
extends Interval {
    private static final long serialVersionUID = 2976113135643438146L;
    protected String id;
    protected Double value;

    public ValuedInterval(String chr, int start, int stop, String id, Double value) {
        super(chr, start, stop);
        this.id = id;
        this.value = value;
    }

    public ValuedInterval(String chr, int start, int stop, String id) {
        this(chr, start, stop, id, null);
    }

    public ValuedInterval(String chr, int start, int stop) {
        this(chr, start, stop, null);
    }

    public ValuedInterval(String chr, int start) {
        this(chr, start, 0);
    }

    public ValuedInterval(String chr) {
        this(chr, 0);
    }

    public ValuedInterval() {
        this(null);
    }

    @Override
    public String toBed() {
        String idStr = this.id == null ? "." : this.id;
        String valueStr = this.value == null ? "." : this.value.toString();
        return this.getChr() + "\t" + (this.low() - 1) + "\t" + this.high() + "\t" + idStr + "\t" + valueStr + "\t" + this.strand();
    }

    @Override
    public String toBedGraph() {
        if (this.value == null) {
            return super.toBedGraph();
        }
        return super.toBedGraph() + "\t" + this.value.toString();
    }

    @Override
    public String toGFF() {
        String idStr = this.id == null ? "no_id" : this.id;
        String valueStr = this.value == null ? "." : this.value.toString();
        return this.getChr() + "\tSpotArray\tfeature\t" + this.low() + "\t" + this.high() + "\t" + valueStr + "\t" + this.strand() + "\t.\tprobe_id=" + idStr + ";count=1";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }
}

