/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dst;

import edu.emory.mathcs.jtransforms.dst.FloatDST_1D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_2D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckFloatDST {
    private static int[] sizes1D = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65536, 131072};
    private static int[] sizes2D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
    private static int[] sizes3D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
    private static double eps = Math.pow(2.0, -23.0);

    private AccuracyCheckFloatDST() {
    }

    public static void checkAccuracyDST_1D() {
        System.out.println("Checking accuracy of 1D DST...");
        for (int i = 0; i < sizes1D.length; ++i) {
            FloatDST_1D floatDST_1D = new FloatDST_1D(sizes1D[i]);
            double d = 0.0;
            float[] fArray = new float[sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], fArray);
            float[] fArray2 = new float[sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], fArray2);
            floatDST_1D.forward(fArray, true);
            floatDST_1D.inverse(fArray, true);
            d = AccuracyCheckFloatDST.computeRMSE(fArray, fArray2);
            if (d > eps) {
                System.err.println("\tsize = " + sizes1D[i] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes1D[i] + ";\terror = " + d);
            }
            fArray = null;
            fArray2 = null;
            floatDST_1D = null;
            System.gc();
        }
    }

    public static void checkAccuracyDST_2D() {
        Object object;
        Object object2;
        double d;
        FloatDST_2D floatDST_2D;
        int n;
        System.out.println("Checking accuracy of 2D DST (float[] input)...");
        for (n = 0; n < sizes2D.length; ++n) {
            floatDST_2D = new FloatDST_2D(sizes2D[n], sizes2D[n]);
            d = 0.0;
            object2 = new float[sizes2D[n] * sizes2D[n]];
            IOUtils.fillMatrix_2D(sizes2D[n], sizes2D[n], object2);
            object = new float[sizes2D[n] * sizes2D[n]];
            IOUtils.fillMatrix_2D(sizes2D[n], sizes2D[n], object);
            floatDST_2D.forward((float[])object2, true);
            floatDST_2D.inverse((float[])object2, true);
            d = AccuracyCheckFloatDST.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            floatDST_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D DST (float[][] input)...");
        for (n = 0; n < sizes2D.length; ++n) {
            floatDST_2D = new FloatDST_2D(sizes2D[n], sizes2D[n]);
            d = 0.0;
            object2 = new float[sizes2D[n]][sizes2D[n]];
            IOUtils.fillMatrix_2D(sizes2D[n], sizes2D[n], (float[][])object2);
            object = new float[sizes2D[n]][sizes2D[n]];
            IOUtils.fillMatrix_2D(sizes2D[n], sizes2D[n], (float[][])object);
            floatDST_2D.forward((float[][])object2, true);
            floatDST_2D.inverse((float[][])object2, true);
            d = AccuracyCheckFloatDST.computeRMSE((float[][])object2, (float[][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            floatDST_2D = null;
            System.gc();
        }
    }

    public static void checkAccuracyDST_3D() {
        Object object;
        Object object2;
        double d;
        FloatDST_3D floatDST_3D;
        int n;
        System.out.println("Checking accuracy of 3D DST (float[] input)...");
        for (n = 0; n < sizes3D.length; ++n) {
            floatDST_3D = new FloatDST_3D(sizes3D[n], sizes3D[n], sizes3D[n]);
            d = 0.0;
            object2 = new float[sizes3D[n] * sizes3D[n] * sizes3D[n]];
            IOUtils.fillMatrix_3D(sizes3D[n], sizes3D[n], sizes3D[n], object2);
            object = new float[sizes3D[n] * sizes3D[n] * sizes3D[n]];
            IOUtils.fillMatrix_3D(sizes3D[n], sizes3D[n], sizes3D[n], object);
            floatDST_3D.forward((float[])object2, true);
            floatDST_3D.inverse((float[])object2, true);
            d = AccuracyCheckFloatDST.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            floatDST_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D DST (float[][][] input)...");
        for (n = 0; n < sizes3D.length; ++n) {
            floatDST_3D = new FloatDST_3D(sizes3D[n], sizes3D[n], sizes3D[n]);
            d = 0.0;
            object2 = new float[sizes3D[n]][sizes3D[n]][sizes3D[n]];
            IOUtils.fillMatrix_3D(sizes3D[n], sizes3D[n], sizes3D[n], (float[][][])object2);
            object = new float[sizes3D[n]][sizes3D[n]][sizes3D[n]];
            IOUtils.fillMatrix_3D(sizes3D[n], sizes3D[n], sizes3D[n], (float[][][])object);
            floatDST_3D.forward((float[][][])object2, true);
            floatDST_3D.inverse((float[][][])object2, true);
            d = AccuracyCheckFloatDST.computeRMSE((float[][][])object2, (float[][][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            floatDST_3D = null;
            System.gc();
        }
    }

    private static double computeRMSE(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            double d2 = fArray[i] - fArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d / (double)fArray.length);
    }

    private static double computeRMSE(float[][] fArray, float[][] fArray2) {
        if (fArray.length != fArray2.length || fArray[0].length != fArray2[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[0].length; ++j) {
                double d2 = fArray[i][j] - fArray2[i][j];
                d += d2 * d2;
            }
        }
        return Math.sqrt(d / (double)(fArray.length * fArray[0].length));
    }

    private static double computeRMSE(float[][][] fArray, float[][][] fArray2) {
        if (fArray.length != fArray2.length || fArray[0].length != fArray2[0].length || fArray[0][0].length != fArray2[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[0].length; ++j) {
                for (int k = 0; k < fArray[0][0].length; ++k) {
                    double d2 = fArray[i][j][k] - fArray2[i][j][k];
                    d += d2 * d2;
                }
            }
        }
        return Math.sqrt(d / (double)(fArray.length * fArray[0].length * fArray[0][0].length));
    }

    public static void main(String[] stringArray) {
        AccuracyCheckFloatDST.checkAccuracyDST_1D();
        AccuracyCheckFloatDST.checkAccuracyDST_2D();
        AccuracyCheckFloatDST.checkAccuracyDST_3D();
        System.exit(0);
    }
}

