/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.Interval;
import edu.unc.genomics.IntervalFactory;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.StringIntervalIterator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;
import net.sf.samtools.TabixReader;

public class TabixFile<T extends Interval>
extends IntervalFile<T> {
    private TabixReader reader;
    private IntervalFactory<T> factory;

    protected TabixFile(Path p, IntervalFactory<T> factory) throws IOException {
        super(p);
        this.factory = factory;
        this.reader = new TabixReader(p);
    }

    @Override
    public Iterator<T> iterator() {
        return new StringIntervalIterator<T>(this.reader.iterator(), this.factory);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Iterator<T> query(String chr, int start, int stop) throws UnsupportedOperationException {
        return new StringIntervalIterator<T>(this.reader.query(chr, start, stop), this.factory);
    }

    @Override
    public int count() {
        int count = 0;
        for (Interval i : this) {
            ++count;
        }
        return count;
    }

    @Override
    public Set<String> chromosomes() {
        return this.reader.chromosomes();
    }
}

