/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.WigItem;

public class Subtract
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Subtract.class);
    @Parameter(names={"-m", "--minuend"}, description="Minuend (top - file 1)", required=true)
    public WigFile minuendFile;
    @Parameter(names={"-s", "--subtrahend"}, description="Subtrahend (bottom - file 2)", required=true)
    public WigFile subtrahendFile;

    @Override
    public void setup() {
        log.debug((Object)"Initializing input files");
        this.inputs.add(this.minuendFile);
        this.inputs.add(this.subtrahendFile);
        log.debug((Object)("Initialized " + this.inputs.size() + " input files"));
    }

    @Override
    public float[] compute(String chr, int start, int stop) throws IOException, WigFileException {
        log.debug((Object)("Computing difference for chunk " + chr + ":" + start + "-" + stop));
        Iterator minuendData = this.minuendFile.query(chr, start, stop);
        Iterator subtrahendData = this.subtrahendFile.query(chr, start, stop);
        float[] result = WigFile.flattenData((Iterator)minuendData, (int)start, (int)stop);
        while (subtrahendData.hasNext()) {
            WigItem item = (WigItem)subtrahendData.next();
            for (int i = item.getStartBase(); i <= item.getEndBase(); ++i) {
                if (i - start < 0 || i - start >= result.length) continue;
                int n = i - start;
                result[n] = result[n] - item.getWigValue();
            }
        }
        return result;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new Subtract().instanceMain(args);
    }
}

