/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class Autocorrelation
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(Autocorrelation.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile wig;
    @Parameter(names={"-l", "--loci"}, description="Genomic loci (Bed format)", required=true)
    public IntervalFile<? extends Interval> loci;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    @Parameter(names={"-m", "--max"}, description="Autocorrelation limit (bp)")
    public int limit = 200;

    private void abs2(float[] data) {
        for (int i = 0; i < data.length; i += 2) {
            data[i] = data[i] * data[i] + data[i + 1] * data[i + 1];
            data[i + 1] = 0.0f;
        }
    }

    @Override
    public void run() throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            log.debug((Object)"Computing autocorrelation for each window");
            int skipped = 0;
            for (Interval interval : this.loci) {
                Iterator wigIter;
                if (interval.length() < this.limit) {
                    log.debug((Object)("Skipping interval: " + interval.toString()));
                    ++skipped;
                    continue;
                }
                try {
                    wigIter = this.wig.query(interval);
                }
                catch (WigFileException | IOException e) {
                    log.debug((Object)("Skipping interval: " + interval.toString()));
                    ++skipped;
                    continue;
                }
                float[] data = WigFile.flattenData((Iterator)wigIter, (int)interval.getStart(), (int)interval.getStop());
                FloatFFT_1D fft = new FloatFFT_1D(data.length);
                fft.realForward(data);
                this.abs2(data);
                fft.realInverse(data, true);
                writer.write(StringUtils.join((Object[])new Serializable[]{data, "\t"}));
                writer.newLine();
            }
            log.info((Object)("Skipped " + skipped + " intervals"));
        }
    }

    public static void main(String[] args) {
        new Autocorrelation().instanceMain(args);
    }
}

