/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.nucleosomes.NucleosomeCall;
import edu.unc.utils.SortUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class GreedyCaller
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(GreedyCaller.class);
    @Parameter(names={"-d", "--dyads"}, description="Dyad counts file", required=true, validateWith=ReadablePathValidator.class)
    public WigFile dyadsFile;
    @Parameter(names={"-s", "--smoothed"}, description="Smoothed dyad counts file", required=true, validateWith=ReadablePathValidator.class)
    public WigFile smoothedDyadsFile;
    @Parameter(names={"-n", "--size"}, description="Nucleosome size (bp)")
    public int nucleosomeSize = 147;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        int halfNuc = this.nucleosomeSize / 2;
        int count = 0;
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            for (String chr : this.smoothedDyadsFile.chromosomes()) {
                log.debug((Object)("Processing chromosome " + chr));
                int chunkStart = this.smoothedDyadsFile.getChrStart(chr);
                int chrStop = this.smoothedDyadsFile.getChrStop(chr);
                while (chunkStart < chrStop) {
                    Iterator smoothedIter;
                    Iterator dyadsIter;
                    int chunkStop = Math.min(chunkStart + 100000 - 1, this.smoothedDyadsFile.getChrStop(chr));
                    int paddedStart = Math.max(chunkStart - this.nucleosomeSize, 1);
                    int paddedStop = Math.min(chunkStop + this.nucleosomeSize, this.smoothedDyadsFile.getChrStop(chr));
                    log.debug((Object)("Processing chunk " + chunkStart + "-" + chunkStop));
                    log.debug((Object)"Loading data and sorting");
                    try {
                        dyadsIter = this.dyadsFile.query(chr, paddedStart, paddedStop);
                        smoothedIter = this.smoothedDyadsFile.query(chr, paddedStart, paddedStop);
                    }
                    catch (WigFileException | IOException e) {
                        e.printStackTrace();
                        throw new CommandLineToolException("Error loading data from Wig file");
                    }
                    float[] dyads = WigFile.flattenData((Iterator)dyadsIter, (int)paddedStart, (int)paddedStop);
                    float[] smoothed = WigFile.flattenData((Iterator)smoothedIter, (int)paddedStart, (int)paddedStop);
                    int[] sortedIndices = SortUtils.indexSort(smoothed);
                    log.debug((Object)"Calling nucleosomes");
                    for (int j = sortedIndices.length - 1; j >= 0; --j) {
                        int i = sortedIndices[j];
                        int dyad = paddedStart + i;
                        if (!(smoothed[i] > 0.0f)) continue;
                        int nucStart = Math.max(paddedStart, dyad - halfNuc);
                        int nucStop = Math.min(dyad + halfNuc, paddedStop);
                        NucleosomeCall call = new NucleosomeCall(chr, nucStart, nucStop);
                        call.setDyad(dyad);
                        double occupancy = 0.0;
                        double weightedSum = 0.0;
                        double smoothedSum = 0.0;
                        double sumOfSquares = 0.0;
                        for (int bp = nucStart; bp <= nucStop; ++bp) {
                            occupancy += (double)dyads[bp - paddedStart];
                            weightedSum += (double)((float)bp * dyads[bp - paddedStart]);
                            smoothedSum += (double)smoothed[bp - paddedStart];
                            sumOfSquares += (double)((float)(bp * bp) * dyads[bp - paddedStart]);
                        }
                        call.setOccupancy(occupancy);
                        if (!(occupancy > 0.0)) continue;
                        call.setDyadMean((int)Math.round(weightedSum / occupancy));
                        call.setConditionalPosition((double)smoothed[i] / smoothedSum);
                        double variance = (sumOfSquares - weightedSum * (double)call.getDyadMean()) / occupancy;
                        call.setDyadStdev(Math.sqrt(variance));
                        if (chunkStart <= dyad && dyad <= chunkStop) {
                            writer.write(call.toString());
                            writer.newLine();
                            ++count;
                        }
                        int low = Math.max(i - this.nucleosomeSize, 0);
                        int high = Math.min(i + this.nucleosomeSize, smoothed.length - 1);
                        for (int k = low; k <= high; ++k) {
                            smoothed[k] = 0.0f;
                        }
                    }
                    chunkStart = chunkStop + 1;
                }
            }
        }
        log.info((Object)("Called " + count + " nucleosomes"));
    }

    public static void main(String[] args) {
        new GreedyCaller().instanceMain(args);
    }
}

