/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.mg4j.document.AbstractDocumentCollection;
import it.unimi.dsi.mg4j.document.AbstractDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.WordReader;
import it.unimi.dsi.mg4j.tool.VirtualDocumentResolver;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.parser.callback.AnchorExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapVirtualDocumentCollection
extends AbstractDocumentCollection {
    public final Int2ObjectMap<? extends CharSequence>[] virtual;
    final DocumentFactory factory = new MapVirtualDocumentFactory();

    public MapVirtualDocumentCollection(Int2ObjectMap<? extends CharSequence> ... virtual) {
        this.virtual = virtual;
    }

    @Override
    public int size() {
        return this.virtual.length;
    }

    @Override
    public Document document(final int index) {
        return new Document(){

            public void close() {
            }

            public Object content(int field) throws IOException {
                MapVirtualDocumentCollection.this.ensureDocumentIndex(index);
                ObjectArrayList result = new ObjectArrayList();
                for (Map.Entry entry : MapVirtualDocumentCollection.this.virtual[index].entrySet()) {
                    result.add((Object)new AnchorExtractor.Anchor(new MutableString(((Integer)entry.getKey()).toString()), new MutableString((CharSequence)entry.getValue())));
                }
                return result;
            }

            public CharSequence title() {
                return null;
            }

            public CharSequence uri() {
                return null;
            }

            public WordReader wordReader(int field) {
                return new FastBufferedReader();
            }
        };
    }

    @Override
    public InputStream stream(int index) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reference2ObjectMap<Enum<?>, Object> metadata(int index) throws IOException {
        return Reference2ObjectMaps.EMPTY_MAP;
    }

    @Override
    public DocumentCollection copy() {
        return this;
    }

    @Override
    public DocumentFactory factory() {
        return this.factory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MapVirtualDocumentFactory
    extends AbstractDocumentFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public DocumentFactory copy() {
            return this;
        }

        @Override
        public int fieldIndex(String fieldName) {
            if ("virtual".equals(fieldName)) {
                return 0;
            }
            return -1;
        }

        @Override
        public String fieldName(int field) {
            this.ensureFieldIndex(field);
            return "virtual";
        }

        @Override
        public DocumentFactory.FieldType fieldType(int field) {
            this.ensureFieldIndex(field);
            return DocumentFactory.FieldType.VIRTUAL;
        }

        @Override
        public Document getDocument(InputStream rawContent, Reference2ObjectMap<Enum<?>, Object> metadata) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int numberOfFields() {
            return 1;
        }
    }

    public static final class TrivialVirtualDocumentResolver
    implements VirtualDocumentResolver {
        private static final long serialVersionUID = 1L;
        private int numberOfDocuments;

        public int numberOfDocuments() {
            return this.numberOfDocuments;
        }

        public void context(Document document) {
        }

        public int resolve(CharSequence virtualDocumentSpec) {
            int d = Integer.parseInt(((Object)virtualDocumentSpec).toString());
            return d < 0 || d >= this.numberOfDocuments ? -1 : d;
        }

        public TrivialVirtualDocumentResolver(int numberOfDocuments) {
            this.numberOfDocuments = numberOfDocuments;
        }
    }
}

