/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.Interval;
import edu.unc.genomics.IntervalFactory;
import edu.unc.genomics.io.BufferedLineReader;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.StringIntervalIterator;
import edu.unc.genomics.io.TabixFile;
import edu.unc.genomics.util.FileUtils;
import edu.unc.genomics.util.Tabix;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.samtools.TabixWriter;
import org.apache.log4j.Logger;

public abstract class TextIntervalFile<T extends Interval>
extends IntervalFile<T> {
    private static final Logger log = Logger.getLogger(TextIntervalFile.class);
    protected IntervalFactory<T> factory;
    private Set<String> chromosomes;
    private int count = 0;
    private final BufferedReader reader;
    private final Iterator<T> iter;
    private Path bgzip;
    private Path index;
    private TabixFile<T> tabixFile;

    protected TextIntervalFile(Path p, IntervalFactory<T> factory) throws IOException {
        super(p);
        this.factory = factory;
        this.reader = Files.newBufferedReader(p, Charset.defaultCharset());
        BufferedLineReader lineReader = new BufferedLineReader(this.reader);
        this.iter = new StringIntervalIterator<T>(lineReader.iterator(), factory);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        if (this.bgzip != null) {
            Files.deleteIfExists(this.bgzip);
        }
        if (this.index != null) {
            Files.deleteIfExists(this.index);
        }
    }

    @Override
    public Set<String> chromosomes() {
        if (this.chromosomes == null) {
            if (this.tabixFile != null) {
                this.chromosomes = this.tabixFile.chromosomes();
            } else {
                this.chromosomes = new HashSet<String>();
                this.count = 0;
                for (Interval i : this) {
                    this.chromosomes.add(i.getChr());
                    ++this.count;
                }
            }
        }
        return this.chromosomes;
    }

    @Override
    public int count() {
        if (this.count == 0) {
            if (this.tabixFile != null) {
                this.count = this.tabixFile.count();
            } else {
                try {
                    this.count = FileUtils.countLines(this.p);
                }
                catch (IOException e) {
                    log.error((Object)("Error counting lines in file: " + this.p));
                    throw new RuntimeException("Error counting lines in file");
                }
            }
        }
        return this.count;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iter;
    }

    @Override
    public Iterator<T> query(String chr, int start, int stop) {
        if (this.tabixFile == null) {
            this.convertToTabix();
        }
        return this.tabixFile.query(chr, start, stop);
    }

    private void convertToTabix() {
        Path sorted = this.p.resolveSibling(this.p.getFileName() + ".sorted");
        try {
            Tabix.sortFile(this.p, sorted, this.factory.tabixConf());
        }
        catch (IOException e3) {
            log.error((Object)"Error sorting interval file for Tabix lookup");
            throw new RuntimeException("Error sorting interval file");
        }
        this.bgzip = this.p.resolveSibling(this.p.getFileName() + ".gz");
        try {
            Tabix.bgzip(sorted, this.bgzip);
        }
        catch (IOException e2) {
            log.error((Object)"Error BGZipping interval file for Tabix lookup");
            e2.printStackTrace();
            throw new RuntimeException("Error initializing Tabix file");
        }
        try {
            Files.delete(sorted);
        }
        catch (IOException e1) {
            log.warn((Object)"Error deleting temporary sorted interval file");
            e1.printStackTrace();
        }
        try {
            this.index = Tabix.index(this.bgzip, this.factory.tabixConf());
        }
        catch (IOException | TabixWriter.TabixException e1) {
            log.error((Object)"Error indexing with Tabix");
            e1.printStackTrace();
            throw new RuntimeException("Error initializing Tabix file");
        }
        try {
            this.tabixFile = new TabixFile<T>(this.bgzip, this.factory);
        }
        catch (IOException e) {
            log.error((Object)"Error initializing Tabix file");
            e.printStackTrace();
            throw new RuntimeException("Error initializing Tabix file");
        }
    }
}

