/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Contig;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import edu.unc.genomics.io.WigFileWriter;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class DynaPro
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(DynaPro.class);
    @Parameter(names={"-i", "--input"}, description="Energy landscape", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-n", "--size"}, description="Nucleosome size (bp)")
    public int nucleosomeSize = 147;
    @Parameter(names={"-m", "--mean"}, description="Shift energy landscape to have mean")
    public Double newMean;
    @Parameter(names={"-v", "--variance"}, description="Scale energy landscape to variance")
    public Double newVar;
    @Parameter(names={"-o", "--output"}, description="Output file (Wig)", required=true)
    public Path outputFile;
    Float shift;
    Float scale;

    @Override
    public void run() throws IOException {
        TrackHeader header = TrackHeader.newWiggle();
        try (WigFileReader reader = WigFileReader.autodetect((Path)this.inputFile);
             WigFileWriter writer = new WigFileWriter(this.outputFile, header);){
            if (this.newMean != null) {
                log.debug((Object)("Shifting mean of energy landscape from " + reader.mean() + " to " + this.newMean));
                this.shift = Float.valueOf((float)(this.newMean - reader.mean()));
            }
            if (this.newVar != null) {
                log.debug((Object)("Rescaling variance of energy landscape from " + Math.pow(reader.stdev(), 2.0) + " to " + this.newVar));
                this.scale = Float.valueOf((float)Math.sqrt(this.newVar / Math.pow(reader.stdev(), 2.0)));
            }
            for (String chr : reader.chromosomes()) {
                int i;
                log.debug((Object)("Processing chromosome " + chr));
                int start = reader.getChrStart(chr);
                int stop = reader.getChrStop(chr);
                float[] energy = reader.query(chr, start, stop).getValues();
                for (i = 0; i < energy.length; ++i) {
                    if (!Float.isNaN(energy[i])) continue;
                    energy[i] = 0.0f;
                }
                if (this.shift != null) {
                    i = 0;
                    while (i < energy.length) {
                        int n = i++;
                        energy[n] = energy[n] + this.shift.floatValue();
                    }
                }
                if (this.scale != null) {
                    i = 0;
                    while (i < energy.length) {
                        int n = i++;
                        energy[n] = energy[n] * this.scale.floatValue();
                    }
                }
                float[] forward = new float[energy.length];
                for (int i2 = this.nucleosomeSize; i2 < energy.length; ++i2) {
                    double factor = 1.0 + Math.exp(forward[i2 - this.nucleosomeSize] - forward[i2 - 1] - energy[i2 - this.nucleosomeSize]);
                    forward[i2] = (float)((double)forward[i2 - 1] + Math.log(factor));
                }
                float[] backward = new float[energy.length];
                for (int i3 = energy.length - this.nucleosomeSize - 1; i3 > 0; --i3) {
                    double factor = 1.0 + Math.exp(backward[i3 + this.nucleosomeSize] - backward[i3 + 1] - energy[i3 - 1]);
                    backward[i3] = (float)((double)backward[i3 + 1] + Math.log(factor));
                }
                float[] p = new float[energy.length];
                for (int i4 = 0; i4 < energy.length - this.nucleosomeSize; ++i4) {
                    p[i4] = (float)Math.exp(forward[i4] - energy[i4] + backward[i4 + this.nucleosomeSize] - backward[1]);
                }
                writer.write(new Contig(chr, start, stop, p));
            }
        }
        catch (WigFileException e) {
            log.error((Object)"Error getting data from Wig file");
            e.printStackTrace();
            throw new CommandLineToolException("Error getting data from Wig file");
        }
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new DynaPro().instanceMain(args);
    }
}

