/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFileWalker;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.SequenceUtil;

public abstract class SinglePassSamProgram
extends CommandLineProgram {
    @Option(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="File to write the output to.")
    public File OUTPUT;
    @Option(shortName="R", doc="Reference sequence fasta", optional=true)
    public File REFERENCE_SEQUENCE;
    @Option(doc="If true (default), then the sort order in the header file will be ignored.", shortName="AS")
    public boolean ASSUME_SORTED = true;
    @Option(doc="Stop after processing N reads, mainly for debugging.")
    public long STOP_AFTER = 0L;
    private static final Log log = Log.getInstance(SinglePassSamProgram.class);

    @Override
    protected final int doWork() {
        SinglePassSamProgram.makeItSo(this.INPUT, this.REFERENCE_SEQUENCE, this.ASSUME_SORTED, this.STOP_AFTER, Arrays.asList(this));
        return 0;
    }

    protected static void makeItSo(File input, File referenceSequence, boolean assumeSorted, long stopAfter, Collection<SinglePassSamProgram> programs) {
        ReferenceSequenceFileWalker walker;
        IoUtil.assertFileIsReadable(input);
        SAMFileReader in = new SAMFileReader(input);
        if (referenceSequence == null) {
            walker = null;
        } else {
            IoUtil.assertFileIsReadable(referenceSequence);
            walker = new ReferenceSequenceFileWalker(referenceSequence);
            if (!in.getFileHeader().getSequenceDictionary().isEmpty()) {
                SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)in.getFileHeader().getSequenceDictionary(), (SAMSequenceDictionary)walker.getSequenceDictionary());
            }
        }
        SAMFileHeader.SortOrder sort = in.getFileHeader().getSortOrder();
        if (sort != SAMFileHeader.SortOrder.coordinate) {
            if (assumeSorted) {
                log.warn("File reports sort order '" + sort + "', assuming it's coordinate sorted anyway.");
            } else {
                throw new PicardException("File " + input.getAbsolutePath() + " should be coordinate sorted but " + "the header says the sort order is " + sort + ". If you believe the file " + "to be coordinate sorted you may pass ASSUME_SORTED=true");
            }
        }
        boolean anyUseNoRefReads = false;
        for (SinglePassSamProgram program : programs) {
            program.setup(in.getFileHeader(), input);
            anyUseNoRefReads = anyUseNoRefReads || program.usesNoRefReads();
        }
        DecimalFormat fmt = new DecimalFormat("#,###");
        long i = 0L;
        for (SAMRecord rec : in) {
            ReferenceSequence ref = walker == null || rec.getReferenceIndex() == -1 ? null : walker.get(rec.getReferenceIndex());
            for (SinglePassSamProgram program : programs) {
                program.acceptRead(rec, ref);
            }
            if (++i % 1000000L == 0L) {
                String count = fmt.format(i);
                if (i < 100000000L) {
                    count = " " + count;
                }
                if (i < 10000000L) {
                    count = " " + count;
                }
                log.info("Processed " + count + " records.");
            }
            if ((stopAfter <= 0L || i < stopAfter) && (anyUseNoRefReads || rec.getReferenceIndex() != -1)) continue;
            break;
        }
        in.close();
        for (SinglePassSamProgram program : programs) {
            program.finish();
        }
    }

    protected boolean usesNoRefReads() {
        return true;
    }

    protected abstract void setup(SAMFileHeader var1, File var2);

    protected abstract void acceptRead(SAMRecord var1, ReferenceSequence var2);

    protected abstract void finish();
}

