/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.FastMath;

public class Logit
implements DifferentiableUnivariateFunction {
    private final double lo;
    private final double hi;

    public Logit() {
        this(0.0, 1.0);
    }

    public Logit(double lo, double hi) {
        this.lo = lo;
        this.hi = hi;
    }

    public double value(double x) {
        return Logit.value(x, this.lo, this.hi);
    }

    public UnivariateFunction derivative() {
        return new UnivariateFunction(){

            public double value(double x) {
                return (Logit.this.hi - Logit.this.lo) / ((x - Logit.this.lo) * (Logit.this.hi - x));
            }
        };
    }

    private static double value(double x, double lo, double hi) {
        if (x < lo || x > hi) {
            throw new OutOfRangeException(x, (Number)lo, hi);
        }
        return FastMath.log((x - lo) / (hi - x));
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        public double value(double x, double ... param) {
            this.validateParameters(param);
            return Logit.value(x, param[0], param[1]);
        }

        public double[] gradient(double x, double ... param) {
            this.validateParameters(param);
            double lo = param[0];
            double hi = param[1];
            return new double[]{1.0 / (lo - x), 1.0 / (hi - x)};
        }

        private void validateParameters(double[] param) {
            if (param == null) {
                throw new NullArgumentException();
            }
            if (param.length != 2) {
                throw new DimensionMismatchException(param.length, 2);
            }
        }
    }
}

