/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.ValuedInterval;
import edu.unc.genomics.io.IntervalFileFormatException;

public class GeneTrackEntry
extends ValuedInterval {
    private static final long serialVersionUID = 8657984166944604756L;
    private double forward;
    private double reverse;

    public GeneTrackEntry(String chr, int start, int stop) {
        super(chr, start, stop);
    }

    public static GeneTrackEntry parse(String line) {
        if (line.startsWith("#") || line.startsWith("track") || line.startsWith("chrom")) {
            return null;
        }
        String[] entry = line.split("\t");
        if (entry.length < 4) {
            throw new IntervalFileFormatException("Invalid GeneTrack entry has < 4 columns: " + line);
        }
        String chr = entry[0];
        int pos = Integer.parseInt(entry[1]);
        GeneTrackEntry gt = new GeneTrackEntry(chr, pos, pos);
        gt.setForward(Double.parseDouble(entry[2]));
        gt.setReverse(Double.parseDouble(entry[3]));
        return gt;
    }

    @Override
    public Double getValue() {
        return this.forward + this.reverse;
    }

    @Override
    public void setValue(Number value) {
        this.forward = value.doubleValue();
        this.reverse = 0.0;
    }

    public double getForward() {
        return this.forward;
    }

    public void setForward(double forward) {
        this.forward = forward;
    }

    public double getReverse() {
        return this.reverse;
    }

    public void setReverse(double reverse) {
        this.reverse = reverse;
    }
}

