/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.dna;

import com.beust.jcommander.Parameter;
import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.WigFileWriter;
import edu.unc.utils.Samtools;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.sf.picard.reference.FastaSequenceIndex;
import net.sf.picard.reference.FastaSequenceIndexEntry;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.samtools.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.genomeview.dnaproperties.DNAProperty;

public class DNAPropertyCalculator
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(DNAPropertyCalculator.class);
    @Parameter(names={"-i", "--input"}, description="Input file (FASTA)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-p", "--property"}, description="DNA property to calculate", required=true)
    public String propertyName;
    @Parameter(names={"-n", "--normalize"}, description="Output normalized values")
    public boolean normalize = false;
    @Parameter(names={"-o", "--output"}, description="Output file (Wiggle)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        DNAProperty property = DNAProperty.create((String)this.propertyName);
        if (property == null) {
            log.error((Object)("Unknown DNA property: " + this.propertyName + ". Options are " + StringUtils.join((Object[])DNAProperty.values(), (String)",")));
            throw new CommandLineToolException("Unknown DNA property: " + this.propertyName);
        }
        if (!IndexedFastaSequenceFile.canCreateIndexedFastaReader((File)this.inputFile.toFile())) {
            try {
                Samtools.indexFasta(this.inputFile);
            }
            catch (Exception e) {
                log.error((Object)"Error indexing FASTA file with samtools. Is samtools available in the PATH?");
                throw new CommandLineToolException("Error indexing FASTA file with samtools");
            }
        }
        IndexedFastaSequenceFile fasta = new IndexedFastaSequenceFile(this.inputFile.toFile());
        Path indexFile = this.inputFile.resolveSibling(this.inputFile.getFileName() + ".fai");
        FastaSequenceIndex faidx = new FastaSequenceIndex(indexFile.toFile());
        TrackHeader header = TrackHeader.newWiggle();
        header.setName(this.propertyName);
        header.setDescription(this.propertyName);
        try (WigFileWriter writer = new WigFileWriter(this.outputFile, header);){
            for (FastaSequenceIndexEntry contig : faidx) {
                log.debug((Object)("Processing FASTA entry " + contig.getContig() + " (length = " + contig.getSize() + ")"));
                int start = 1;
                while ((long)start <= contig.getSize()) {
                    int stop = (int)Math.min((long)(start + 300000 - 1), contig.getSize());
                    Interval chunk = new Interval(contig.getContig(), start, stop);
                    log.debug((Object)("Processing chunk " + chunk));
                    ReferenceSequence seq = fasta.getSubsequenceAt(contig.getContig(), (long)start, (long)stop);
                    double[] values = this.normalize ? property.normalizedProfile(StringUtil.bytesToString((byte[])seq.getBases())) : property.profile(StringUtil.bytesToString((byte[])seq.getBases()));
                    float[] floatValues = new float[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        floatValues[i] = (float)values[i];
                    }
                    writer.write(new Contig(chunk, floatValues));
                    start = stop + 1;
                }
            }
        }
    }

    public static void main(String[] args) {
        new DNAPropertyCalculator().instanceMain(args);
    }
}

