/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.FastaEntry;
import edu.unc.genomics.io.SequenceFile;
import edu.unc.genomics.io.SequenceFileFormatException;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class FastaFile
extends SequenceFile<FastaEntry> {
    private static final Logger log = Logger.getLogger(FastaFile.class);
    private final BufferedReader reader;
    private final FastaIterator iter;

    protected FastaFile(Path p) throws IOException {
        super(p);
        this.reader = Files.newBufferedReader(p, Charset.defaultCharset());
        this.iter = new FastaIterator();
    }

    @Override
    public Iterator<FastaEntry> iterator() {
        return this.iter;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private class FastaIterator
    implements Iterator<FastaEntry> {
        private String nextLine;

        private FastaIterator() {
            try {
                this.nextLine = FastaFile.this.reader.readLine();
            }
            catch (IOException e) {
                log.error((Object)"Error reading from FASTA file");
                e.printStackTrace();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextLine != null;
        }

        @Override
        public FastaEntry next() {
            if (!this.nextLine.startsWith(">")) {
                throw new SequenceFileFormatException("Invalid format in FASTA file: " + FastaFile.this.p);
            }
            String id = this.nextLine.substring(1);
            StringBuilder seq = new StringBuilder();
            try {
                while ((this.nextLine = FastaFile.this.reader.readLine()) != null && !this.nextLine.startsWith(">")) {
                    seq.append(this.nextLine);
                }
            }
            catch (IOException e) {
                log.error((Object)"Error reading from Fasta file");
                throw new SequenceFileFormatException("Invalid format in FASTA file: " + FastaFile.this.p);
            }
            return new FastaEntry(id, seq.toString());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot delete entries in FASTA file");
        }
    }
}

