/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.mg4j.index.BitStreamIndexWriter;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.SqrtSkipIndex;
import it.unimi.dsi.mg4j.io.FastByteArrayOutputStream;
import it.unimi.dsi.mg4j.io.NullOutputStream;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqrtSkipIndexWriter
extends BitStreamIndexWriter {
    private int q;
    private int cache;
    private int basePointer;
    private OutputBitStream cacheData;
    private FastByteArrayOutputStream cacheDataByte = new FastByteArrayOutputStream();
    private OutputBitStream cachePointer;
    private FastByteArrayOutputStream cachePointerByte;
    private OutputBitStream bitCount;
    public long numberOfBlocks;
    public long bitsForSkips;
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;

    public SqrtSkipIndexWriter(CharSequence basename, int numberOfDocuments, boolean writeOffsets, Map<CompressionFlags.Component, CompressionFlags.Coding> flags) throws IOException {
        this(new OutputBitStream(new FileOutputStream(basename + ".index")), writeOffsets ? new OutputBitStream(new FileOutputStream(basename + ".offsets")) : null, numberOfDocuments, flags);
    }

    public SqrtSkipIndexWriter(OutputBitStream obs, OutputBitStream offset, int N, Map<CompressionFlags.Component, CompressionFlags.Coding> flags) {
        super(obs, offset, N, flags);
        this.cacheData = new OutputBitStream(this.cacheDataByte, 0);
        this.cachePointerByte = new FastByteArrayOutputStream();
        this.cachePointer = new OutputBitStream(this.cachePointerByte, 0);
        this.bitCount = new OutputBitStream(NullOutputStream.getInstance(), 0);
    }

    public SqrtSkipIndexWriter(OutputBitStream obs, int N, Map<CompressionFlags.Component, CompressionFlags.Coding> flags) {
        this(obs, null, N, flags);
    }

    @Override
    public long newInvertedList() throws IOException {
        if (this.cache != 0) {
            this.writeOutCache(-1);
        }
        return super.newInvertedList();
    }

    @Override
    public int writeFrequency(int frequency) throws IOException {
        int res = super.writeFrequency(frequency);
        this.q = (int)Math.max(Math.round(Math.sqrt(frequency)), 16L);
        return res;
    }

    @Override
    public OutputBitStream newDocumentRecord() throws IOException, IllegalStateException {
        super.newDocumentRecord();
        return this.cacheData;
    }

    @Override
    public int writeDocumentPointer(OutputBitStream out, int pointer) throws IOException, IllegalStateException {
        if (this.cache == this.q) {
            this.writeOutCache(pointer);
        }
        if (this.cache++ == 0) {
            this.basePointer = pointer;
            return super.writeDocumentPointer(this.cachePointer, pointer);
        }
        return super.writeDocumentPointer(this.cacheData, pointer);
    }

    private int writeOutPointer(OutputBitStream out, int pointer) throws IOException {
        if (this.frequency == this.numberOfDocuments) {
            return 0;
        }
        switch (this.pointerCoding) {
            case GAMMA: {
                return out.writeGamma(pointer - this.lastDocument - 1);
            }
            case DELTA: {
                return out.writeDelta(pointer - this.lastDocument - 1);
            }
            case GOLOMB: {
                return out.writeGolomb(pointer - this.lastDocument - 1, this.b, this.log2b);
            }
        }
        throw new IllegalStateException("The required pointer coding (" + (Object)((Object)this.pointerCoding) + ") is not supported.");
    }

    @Override
    public void close() throws IOException {
        if (this.cache != 0) {
            this.writeOutCache(-1);
        }
        super.close();
    }

    private void writeOutCache(int nextPointer) throws IOException {
        long toTheEnd;
        int nextPointerAfter;
        if (nextPointer >= 0) {
            nextPointerAfter = nextPointer;
            toTheEnd = this.writeOutPointer(this.bitCount, nextPointer);
        } else {
            nextPointerAfter = this.currentDocument + 1;
            toTheEnd = 0L;
        }
        long d = this.cachePointer.writtenBits();
        this.cachePointer.flush();
        this.obs.write(this.cachePointerByte.array, d);
        if (this.cache == this.q) {
            this.bitsForSkips += (long)this.obs.writeDelta(nextPointerAfter - this.basePointer);
            this.bitsForSkips += (long)this.obs.writeLongDelta(this.cacheData.writtenBits() + toTheEnd);
        }
        d = this.cacheData.writtenBits();
        this.cacheData.flush();
        this.obs.write(this.cacheDataByte.array, d);
        this.cachePointerByte.reset();
        this.cachePointer.writtenBits(0L);
        this.cacheDataByte.reset();
        this.cacheData.writtenBits(0L);
        this.cache = 0;
    }

    @Override
    public long writtenBits() {
        return super.writtenBits() + this.bitsForSkips;
    }

    @Override
    public Properties properties() {
        Properties result = super.properties();
        result.setProperty(Index.PropertyKeys.INDEXCLASS, SqrtSkipIndex.class.getName());
        return result;
    }
}

