/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.remote;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.remote.RemoteBitStreamIndex;
import it.unimi.dsi.mg4j.index.remote.RemoteIndex;
import it.unimi.dsi.mg4j.index.remote.RemoteIndexReader;
import it.unimi.dsi.mg4j.index.remote.RemoteInputStream;
import it.unimi.dsi.mg4j.index.remote.RemoteOffsetList;
import it.unimi.dsi.mg4j.index.remote.RemotePrefixMap;
import it.unimi.dsi.mg4j.index.remote.RemoteSizeList;
import it.unimi.dsi.mg4j.index.remote.RemoteTermMap;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

public class IndexServer {
    public static final int DEFAULT_PORT = 9090;
    private static final Logger LOGGER = Fast.getLogger(IndexServer.class);
    public static final byte GET_INDEX = 0;
    public static final byte GET_INDEX_READER = 1;
    public static final byte GET_TERM_MAP = 2;
    public static final byte GET_PREFIX_MAP = 3;
    public static final byte GET_SIZE_LIST = 4;
    public static final byte GET_OFFSET_LIST = 5;
    public static final byte GET_CLIENT_INPUT_STREAM = 6;

    public static Index getIndex(String host, int port, boolean randomAccess, boolean documentSizes) throws IOException, ClassNotFoundException {
        Socket socket = new Socket(host, port == -1 ? 9090 : port);
        LOGGER.debug((Object)("Accessing remote index at " + host + ":" + port + "..."));
        DataOutputStream outputStream = new DataOutputStream(socket.getOutputStream());
        outputStream.writeByte(0);
        outputStream.writeBoolean(randomAccess);
        outputStream.writeBoolean(documentSizes);
        outputStream.flush();
        Index index = (Index)BinIO.loadObject((InputStream)socket.getInputStream());
        socket.close();
        LOGGER.debug((Object)("Index at " + socket + " downloaded: " + index));
        return index;
    }

    public static void start(Index index, ServerSocket serverSocket, boolean forceRemoteIndex) throws IOException {
        LOGGER.info((Object)("Index server started at " + serverSocket.getLocalSocketAddress()));
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        SocketAddress localSocketAddress = serverSocket.getLocalSocketAddress();
        while (true) {
            Socket socket = serverSocket.accept();
            int command = socket.getInputStream().read();
            LOGGER.debug((Object)("Remote command: " + command));
            switch (command) {
                case 0: {
                    DataInputStream dis = new DataInputStream(socket.getInputStream());
                    DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
                    boolean randomAccess = dis.readBoolean();
                    boolean documentSizes = dis.readBoolean();
                    if (index instanceof BitStreamIndex && !forceRemoteIndex) {
                        BitStreamIndex localIndex = (BitStreamIndex)index;
                        if (randomAccess && localIndex.offsets == null) {
                            randomAccess = false;
                            LOGGER.warn((Object)("Random access will not be available for index " + localIndex));
                        }
                        BinIO.storeObject((Object)new RemoteBitStreamIndex(localSocketAddress, index.numberOfDocuments, index.numberOfTerms, index.numberOfPostings, index.numberOfOccurrences, index.maxCount, localIndex.payload, localIndex.frequencyCoding, localIndex.pointerCoding, localIndex.countCoding, localIndex.positionCoding, localIndex.quantum, localIndex.height, localIndex.bufferSize, localIndex.termProcessor, localIndex.field, localIndex.properties, localIndex.termMap != null ? new RemoteTermMap(localSocketAddress, index.numberOfTerms) : null, localIndex.prefixMap != null ? new RemotePrefixMap(localSocketAddress, index.numberOfTerms) : null, (IntList)(localIndex.positionCoding == CompressionFlags.Coding.GOLOMB || localIndex.positionCoding == CompressionFlags.Coding.INTERPOLATIVE ? localIndex.sizes : (documentSizes ? new RemoteSizeList(localSocketAddress, localIndex.numberOfDocuments) : null)), (LongList)(randomAccess ? new RemoteOffsetList(localSocketAddress, localIndex.offsets.size()) : null)), (OutputStream)dos);
                    } else {
                        BinIO.storeObject((Object)new RemoteIndex(localSocketAddress, index.numberOfDocuments, index.numberOfTerms, index.numberOfPostings, index.numberOfOccurrences, index.maxCount, index.payload, index.hasCounts, index.hasPositions, index.termProcessor, index.field, (IntList)(documentSizes ? new RemoteSizeList(localSocketAddress, index.numberOfDocuments) : null), index.properties), (OutputStream)dos);
                    }
                    dos.flush();
                    break;
                }
                case 1: {
                    threadPool.execute(new RemoteIndexReader.ServerThread(socket, index));
                    break;
                }
                case 2: {
                    threadPool.execute(new RemoteTermMap.ServerThread(socket, ((BitStreamIndex)index).termMap));
                    break;
                }
                case 3: {
                    threadPool.execute(new RemotePrefixMap.ServerThread(socket, ((BitStreamIndex)index).prefixMap));
                    break;
                }
                case 4: {
                    threadPool.execute(new RemoteSizeList.ServerThread(socket, index.sizes));
                    break;
                }
                case 5: {
                    threadPool.execute(new RemoteOffsetList.ServerThread(socket, ((BitStreamIndex)index).offsets));
                    break;
                }
                case 6: {
                    threadPool.execute(new RemoteInputStream.ServerThread(socket, ((BitStreamIndex)index).getInputStream()));
                }
            }
        }
    }

    public static void start(Index index, InetAddress address, int port, boolean forceRemoteIndex) throws IOException {
        IndexServer.start(index, new ServerSocket(port, 0, address), forceRemoteIndex);
    }

    public static void main(String[] arg) throws ConfigurationException, IOException, URISyntaxException, ClassNotFoundException, JSAPException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        SimpleJSAP jsap = new SimpleJSAP(IndexServer.class.getName(), "Starts a server index daemon.", new Parameter[]{new FlaggedOption("port", (StringParser)JSAP.INTEGER_PARSER, "9090", false, 'p', "port", "The server port."), new Switch("forceremote", 'f', "force-remote", "Forces a remote index instead of a remote bitstream index."), new UnflaggedOption("ipaddr", (StringParser)JSAP.INETADDRESS_PARSER, true, "The server address."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, true, "The basename or uri of the index")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int port = jsapResult.getInt("port");
        String basename = jsapResult.getString("basename");
        boolean forceRemote = jsapResult.getBoolean("forceremote");
        IndexServer.start(Index.getInstance(basename), jsapResult.getInetAddress("ipaddr"), port, forceRemote);
    }
}

