/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.JobException;
import edu.unc.genomics.ThreadFilter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.Filter;

public class Job
implements Iterable<ParameterDescription>,
Runnable {
    private static final Logger log = Logger.getLogger(Job.class);
    private final Class<? extends CommandLineTool> tool;
    private final CommandLineTool app;
    private final List<ParameterDescription> parameters;
    private final String usageText;
    private boolean isRunning = false;
    private StringWriter writer = new StringWriter();
    private Map<ParameterDescription, String> args = new HashMap<ParameterDescription, String>();

    public Job(Class<? extends CommandLineTool> tool) throws InstantiationException, IllegalAccessException {
        this.tool = tool;
        this.app = tool.newInstance();
        JCommander jc = new JCommander((Object)this.app);
        jc.setProgramName(tool.getSimpleName());
        this.parameters = jc.getParameters();
        StringBuilder sbuilder = new StringBuilder();
        jc.usage(sbuilder);
        this.usageText = sbuilder.toString();
        for (ParameterDescription param : this.parameters) {
            if (param.getDefault() == null) continue;
            this.setArgument(param, String.valueOf(param.getDefault()));
        }
    }

    public Job(Job job) {
        this.tool = job.tool;
        this.app = job.app;
        this.parameters = job.parameters;
        this.args = job.args;
        this.usageText = job.usageText;
    }

    @Override
    public void run() {
        String[] args;
        try {
            args = this.getArguments();
        }
        catch (JobException e) {
            e.printStackTrace();
            throw new CommandLineToolException("Job arguments are not valid");
        }
        WriterAppender appender = new WriterAppender((Layout)new PatternLayout(), (Writer)this.writer);
        appender.addFilter((Filter)new ThreadFilter(Thread.currentThread().getName()));
        Logger.getRootLogger().addAppender((Appender)appender);
        this.isRunning = true;
        this.app.toolRunnerMain(args);
        this.isRunning = false;
        Logger.getRootLogger().removeAppender((Appender)appender);
    }

    public String[] getArguments() throws JobException {
        if (!this.validateArguments()) {
            throw new JobException("Job Arguments are not valid");
        }
        ArrayList<String> cmdArgs = new ArrayList<String>();
        for (ParameterDescription p : this.args.keySet()) {
            cmdArgs.add(p.getLongestName());
            cmdArgs.add(this.args.get(p));
        }
        String[] ret = new String[cmdArgs.size()];
        return cmdArgs.toArray(ret);
    }

    public String getArgument(ParameterDescription p) {
        return this.args.get(p);
    }

    public void setArgument(ParameterDescription p, String value) {
        if (value.length() == 0) {
            this.args.remove(p);
        } else {
            this.args.put(p, value);
        }
    }

    public void resetArguments() {
        this.args.clear();
    }

    public boolean isSet(ParameterDescription p) {
        return this.args.containsKey(p);
    }

    public boolean validateArguments() {
        boolean hasAllRequiredParams = true;
        for (ParameterDescription param : this.parameters) {
            if (!param.getParameter().required() || this.isSet(param)) continue;
            log.debug((Object)("Job is missing required argument: " + param.getLongestName()));
            hasAllRequiredParams = false;
        }
        return hasAllRequiredParams;
    }

    public int numParameters() {
        return this.parameters.size();
    }

    @Override
    public Iterator<ParameterDescription> iterator() {
        return this.parameters.iterator();
    }

    public String getName() {
        return this.tool.getSimpleName();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public String getUsageText() {
        return this.usageText;
    }

    public String toString() {
        return this.getName();
    }

    public String getOutput() {
        return this.writer.toString();
    }
}

