/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import cern.colt.bitvector.QuickBitVector;
import cern.jet.random.engine.MersenneTwister;
import java.io.Serializable;
import java.util.Random;

public class IntBloomFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int m;
    public final int d;
    private final long[] bits;
    private final int[] a;
    private final int[] b;
    private static final double NATURAL_LOG_OF_2 = Math.log(2.0);
    private static final boolean DEBUG = false;

    public IntBloomFilter(int n, int d) {
        this.d = d;
        this.bits = new long[(int)Math.ceil((double)(n * d) / NATURAL_LOG_OF_2 / 64.0)];
        if (this.bits.length > 0x1FFFFFF) {
            throw new IllegalArgumentException("This filter would require " + (long)this.bits.length * 64L + " bits");
        }
        this.m = this.bits.length * 64;
        MersenneTwister mersenneTwister = new MersenneTwister(new Random().nextInt());
        this.a = new int[d];
        this.b = new int[d];
        for (int i = 0; i < d; ++i) {
            this.a[i] = mersenneTwister.nextInt();
            this.b[i] = mersenneTwister.nextInt();
        }
    }

    private int hash(int x, int k) {
        return ((this.a[k] * x ^ this.b[k]) & Integer.MAX_VALUE) % this.m;
    }

    public boolean contains(int x) {
        int i = this.d;
        while (i-- != 0) {
            if (QuickBitVector.get((long[])this.bits, (int)this.hash(x, i))) continue;
            return false;
        }
        return true;
    }

    public void add(int x) {
        int i = this.d;
        while (i-- != 0) {
            QuickBitVector.set((long[])this.bits, (int)this.hash(x, i));
        }
    }
}

