/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.document;

import it.unimi.dsi.mg4j.document.CompositeDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.HtmlDocumentFactory;
import it.unimi.dsi.mg4j.document.TRECDocumentCollection;
import it.unimi.dsi.mg4j.document.TRECHeaderDocumentFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;

public class TRECDocumentCollectionTest
extends TestCase {
    public void testChar255() throws Exception {
        File temp = File.createTempFile(TRECDocumentCollectionTest.class.getName(), ".testChar255");
        temp.deleteOnExit();
        FileOutputStream outputStream = new FileOutputStream(temp);
        IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("testChar255.data"), (OutputStream)outputStream);
        ((OutputStream)outputStream).close();
        TRECDocumentCollection collection = new TRECDocumentCollection(new String[]{temp.toString()}, CompositeDocumentFactory.getFactory(new TRECHeaderDocumentFactory(), new HtmlDocumentFactory(new String[]{"encoding=ISO-8859-1"})), 4, false);
        try {
            Document d;
            DocumentIterator iter = collection.iterator();
            while ((d = iter.nextDocument()) != null) {
                d.title();
            }
        }
        catch (IllegalStateException e) {
            TRECDocumentCollectionTest.assertTrue((boolean)false);
        }
    }

    public void testContents() throws Exception {
        File temp = File.createTempFile(TRECDocumentCollectionTest.class.getName(), ".testContents");
        File tempAgain = File.createTempFile(TRECDocumentCollectionTest.class.getName(), ".testContentsAgain");
        temp.deleteOnExit();
        tempAgain.deleteOnExit();
        FileOutputStream outputStream = new FileOutputStream(temp);
        FileOutputStream outputStreamAgain = new FileOutputStream(tempAgain);
        IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("testContents.data"), (OutputStream)outputStream);
        ((OutputStream)outputStream).close();
        IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("testContentsAgain.data"), (OutputStream)outputStreamAgain);
        ((OutputStream)outputStreamAgain).close();
        TRECDocumentCollection collection = new TRECDocumentCollection(new String[]{temp.toString(), tempAgain.toString()}, CompositeDocumentFactory.getFactory(new TRECHeaderDocumentFactory(), new HtmlDocumentFactory(new String[]{"encoding=ISO-8859-1"})), 4, false);
        DocumentIterator iter = collection.iterator();
        Document d = null;
        d = iter.nextDocument();
        TRECDocumentCollectionTest.assertNotNull((Object)d);
        TRECDocumentCollectionTest.assertEquals((Object)"http://gx0001/", (Object)d.uri());
        TRECDocumentCollectionTest.assertEquals((Object)"GX001", (Object)d.title());
        int textIndex = collection.factory().fieldIndex("text");
        TRECDocumentCollectionTest.assertEquals((String)"Line 1\n     The line 2!\n  Mamma\n", (String)IOUtils.toString((Reader)((Reader)d.content(textIndex))));
        d = iter.nextDocument();
        TRECDocumentCollectionTest.assertNotNull((Object)d);
        TRECDocumentCollectionTest.assertEquals((Object)"http://gx0002/", (Object)d.uri());
        TRECDocumentCollectionTest.assertEquals((Object)"GX002", (Object)d.title());
        TRECDocumentCollectionTest.assertEquals((String)"Contents of this file reside on one line only\n", (String)IOUtils.toString((Reader)((Reader)d.content(textIndex))));
        d = iter.nextDocument();
        TRECDocumentCollectionTest.assertNotNull((Object)d);
        TRECDocumentCollectionTest.assertEquals((Object)"http://gx0003/", (Object)d.uri());
        TRECDocumentCollectionTest.assertEquals((Object)"GX003", (Object)d.title());
        TRECDocumentCollectionTest.assertEquals((String)"Line 1\nLine 2\nLine 3\nLine 4\nLine 5\n", (String)IOUtils.toString((Reader)((Reader)d.content(textIndex))));
        d = iter.nextDocument();
        TRECDocumentCollectionTest.assertNotNull((Object)d);
        TRECDocumentCollectionTest.assertEquals((Object)"http://gx0004/", (Object)d.uri());
        TRECDocumentCollectionTest.assertEquals((Object)"GX004", (Object)d.title());
        TRECDocumentCollectionTest.assertEquals((String)"New content 0\n", (String)IOUtils.toString((Reader)((Reader)d.content(textIndex))));
        d = iter.nextDocument();
        TRECDocumentCollectionTest.assertNotNull((Object)d);
        TRECDocumentCollectionTest.assertEquals((Object)"http://gx0005/", (Object)d.uri());
        TRECDocumentCollectionTest.assertEquals((Object)"GX005", (Object)d.title());
        TRECDocumentCollectionTest.assertEquals((String)"New content 1\n", (String)IOUtils.toString((Reader)((Reader)d.content(textIndex))));
        d = iter.nextDocument();
        TRECDocumentCollectionTest.assertNotNull((Object)d);
        TRECDocumentCollectionTest.assertEquals((Object)"http://gx0006/", (Object)d.uri());
        TRECDocumentCollectionTest.assertEquals((Object)"GX006", (Object)d.title());
        TRECDocumentCollectionTest.assertEquals((String)"New content 2\n", (String)IOUtils.toString((Reader)((Reader)d.content(textIndex))));
        d = iter.nextDocument();
        TRECDocumentCollectionTest.assertNotNull((Object)d);
        TRECDocumentCollectionTest.assertEquals((Object)"http://gx0007/", (Object)d.uri());
        TRECDocumentCollectionTest.assertEquals((Object)"GX007", (Object)d.title());
        TRECDocumentCollectionTest.assertEquals((String)"", (String)IOUtils.toString((Reader)((Reader)d.content(textIndex))));
        d = iter.nextDocument();
        TRECDocumentCollectionTest.assertNull((Object)d);
        iter.close();
        d = collection.document(0);
        TRECDocumentCollectionTest.assertNotNull((Object)d);
        TRECDocumentCollectionTest.assertEquals((Object)"http://gx0001/", (Object)d.uri());
        TRECDocumentCollectionTest.assertEquals((Object)"GX001", (Object)d.title());
        TRECDocumentCollectionTest.assertEquals((String)"Line 1\n     The line 2!\n  Mamma\n", (String)IOUtils.toString((Reader)((Reader)d.content(textIndex))));
        d.close();
        d = collection.document(1);
        TRECDocumentCollectionTest.assertNotNull((Object)d);
        TRECDocumentCollectionTest.assertEquals((Object)"http://gx0002/", (Object)d.uri());
        TRECDocumentCollectionTest.assertEquals((Object)"GX002", (Object)d.title());
        TRECDocumentCollectionTest.assertEquals((String)"Contents of this file reside on one line only\n", (String)IOUtils.toString((Reader)((Reader)d.content(textIndex))));
        d.close();
        d = collection.document(2);
        TRECDocumentCollectionTest.assertNotNull((Object)d);
        TRECDocumentCollectionTest.assertEquals((Object)"http://gx0003/", (Object)d.uri());
        TRECDocumentCollectionTest.assertEquals((Object)"GX003", (Object)d.title());
        TRECDocumentCollectionTest.assertEquals((String)"Line 1\nLine 2\nLine 3\nLine 4\nLine 5\n", (String)IOUtils.toString((Reader)((Reader)d.content(textIndex))));
        d.close();
        d = collection.document(3);
        TRECDocumentCollectionTest.assertNotNull((Object)d);
        TRECDocumentCollectionTest.assertEquals((Object)"http://gx0004/", (Object)d.uri());
        TRECDocumentCollectionTest.assertEquals((Object)"GX004", (Object)d.title());
        TRECDocumentCollectionTest.assertEquals((String)"New content 0\n", (String)IOUtils.toString((Reader)((Reader)d.content(textIndex))));
        d.close();
        d = collection.document(4);
        TRECDocumentCollectionTest.assertNotNull((Object)d);
        TRECDocumentCollectionTest.assertEquals((Object)"http://gx0005/", (Object)d.uri());
        TRECDocumentCollectionTest.assertEquals((Object)"GX005", (Object)d.title());
        TRECDocumentCollectionTest.assertEquals((String)"New content 1\n", (String)IOUtils.toString((Reader)((Reader)d.content(textIndex))));
        d.close();
        d = collection.document(5);
        TRECDocumentCollectionTest.assertNotNull((Object)d);
        TRECDocumentCollectionTest.assertEquals((Object)"http://gx0006/", (Object)d.uri());
        TRECDocumentCollectionTest.assertEquals((Object)"GX006", (Object)d.title());
        TRECDocumentCollectionTest.assertEquals((String)"New content 2\n", (String)IOUtils.toString((Reader)((Reader)d.content(textIndex))));
        d.close();
        d = collection.document(6);
        TRECDocumentCollectionTest.assertNotNull((Object)d);
        TRECDocumentCollectionTest.assertEquals((Object)"http://gx0007/", (Object)d.uri());
        TRECDocumentCollectionTest.assertEquals((Object)"GX007", (Object)d.title());
        TRECDocumentCollectionTest.assertEquals((String)"", (String)IOUtils.toString((Reader)((Reader)d.content(textIndex))));
        d.close();
    }
}

