/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.remote;

import it.unimi.dsi.fastutil.ints.AbstractIntList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.mg4j.index.remote.RemoteIndexServerConnection;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.log4j.Logger;

public class RemoteSizeList
extends AbstractIntList
implements Serializable {
    static final long serialVersionUID = 2L;
    private transient RemoteIndexServerConnection connection;
    private SocketAddress address;
    private int size;

    public RemoteSizeList(SocketAddress addr, int size) {
        this.address = addr;
        this.size = size;
    }

    public int getInt(int index) {
        try {
            if (this.connection == null) {
                this.connection = new RemoteIndexServerConnection(this.address, 4);
            }
            this.connection.outputStream.writeInt(index);
            this.connection.outputStream.flush();
            return this.connection.inputStream.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int size() {
        return this.size;
    }

    public static class ServerThread
    extends it.unimi.dsi.mg4j.index.remote.ServerThread {
        private static final boolean DEBUG = false;
        private static final Logger LOGGER = Fast.getLogger(ServerThread.class);
        private final IntList list;

        public ServerThread(Socket socket, IntList list) throws IOException {
            super(socket);
            this.list = list;
        }

        public void run() {
            try {
                while (true) {
                    int index = this.inputStream.readInt();
                    this.outputStream.writeLong(this.list.getInt(index));
                    this.outputStream.flush();
                }
            }
            catch (EOFException e) {
                LOGGER.warn((Object)"The socket has been closed");
            }
            catch (Exception e) {
                LOGGER.fatal((Object)e, (Throwable)e);
            }
        }
    }
}

