/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.io;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.io.MeasurableInputStream;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class SegmentedInputStream
extends MeasurableInputStream {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = Logger.getLogger(SegmentedInputStream.class);
    private InputStream in;
    private int relativePos;
    private int segmentLen;
    private ObjectArrayList<SegmentBlock> blocks;
    private long currentStartMarker;
    private long currentStopMarker;
    private int currentBlock;
    private boolean closed;

    private void ensureBlocksNotEmpty() {
        if (this.blocks.isEmpty()) {
            throw new IllegalStateException("You must add at least one block before reading or closing a segmented stream");
        }
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("This segmented input stream has been closed");
        }
    }

    public SegmentedInputStream(InputStream in) {
        if (in == null) {
            throw new NullPointerException();
        }
        this.in = in;
        this.blocks = new ObjectArrayList();
        this.currentBlock = -1;
    }

    public SegmentedInputStream(InputStream in, long ... delimiter) throws NullPointerException, IOException, IllegalStateException {
        this(in);
        this.addBlock(delimiter);
    }

    private boolean eofInBlock() {
        this.ensureBlocksNotEmpty();
        this.ensureNotClosed();
        return this.relativePos >= this.segmentLen;
    }

    private void nextSegment() throws IOException {
        long diff;
        this.ensureNotClosed();
        SegmentBlock block = (SegmentBlock)this.blocks.get(this.currentBlock);
        if (!block.hasMoreSegments()) {
            return;
        }
        block.nextSegment();
        long absPos = this.currentStartMarker + (long)this.relativePos;
        this.currentStartMarker = block.currentStartMarker();
        this.currentStopMarker = block.currentStopMarker();
        if (this.currentStartMarker - absPos > 0L && (diff = this.in.skip(this.currentStartMarker - absPos)) != this.currentStartMarker - absPos) {
            throw new IllegalStateException("Should have skipped " + (this.currentStartMarker - absPos) + " bytes, got " + diff);
        }
        this.relativePos = 0;
        this.segmentLen = (int)(this.currentStopMarker - this.currentStartMarker);
    }

    public void nextBlock() throws IOException {
        if (!this.hasMoreBlocks()) {
            throw new NoSuchElementException();
        }
        ++this.currentBlock;
        this.nextSegment();
    }

    public boolean hasMoreBlocks() {
        return this.currentBlock < this.blocks.size() - 1;
    }

    public void addBlock(long ... delimiter) throws IllegalArgumentException, IOException {
        this.ensureNotClosed();
        this.blocks.add((Object)new SegmentBlock(delimiter));
        if (this.currentBlock == -1) {
            this.nextBlock();
        }
    }

    public int read() throws IOException {
        this.ensureNotClosed();
        if (this.eofInBlock()) {
            return -1;
        }
        int r = this.in.read();
        ++this.relativePos;
        return r;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureNotClosed();
        ByteArrays.ensureOffsetLength((byte[])b, (int)off, (int)len);
        if (len == 0) {
            return 0;
        }
        if (this.eofInBlock()) {
            return -1;
        }
        int effectivelen = Math.min(this.segmentLen - this.relativePos, len);
        effectivelen = this.in.read(b, off, effectivelen);
        this.relativePos += effectivelen;
        return effectivelen;
    }

    public long skip(long n) throws IOException {
        this.ensureNotClosed();
        if (this.eofInBlock()) {
            return 0L;
        }
        long effectiveskip = Math.max(Math.min((long)(this.segmentLen - this.relativePos), n), 0L);
        effectiveskip = this.in.skip(effectiveskip);
        this.relativePos = (int)((long)this.relativePos + effectiveskip);
        return effectiveskip;
    }

    public int available() throws IOException {
        this.ensureNotClosed();
        if (this.eofInBlock()) {
            return 0;
        }
        return Math.min(this.in.available(), this.segmentLen - this.relativePos);
    }

    public long length() throws IOException {
        this.ensureNotClosed();
        return this.segmentLen;
    }

    public long position() throws IOException {
        this.ensureNotClosed();
        return this.relativePos;
    }

    public void close() throws IOException {
        this.ensureBlocksNotEmpty();
        if (this.closed) {
            return;
        }
        if (this.hasMoreBlocks()) {
            this.nextBlock();
            return;
        }
        this.closed = true;
        this.in.close();
    }

    public void reset() throws IOException {
        this.ensureNotClosed();
        this.nextSegment();
    }

    private static class SegmentBlock {
        final long[] delimiter;
        int currSegment;

        public SegmentBlock(long ... delimiter) throws IllegalArgumentException {
            if (delimiter.length == 0) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < delimiter.length - 1; ++i) {
                if (delimiter[i] <= delimiter[i + 1]) continue;
                throw new IllegalArgumentException("Segment " + (i + 1) + " is inconsistent as it starts after the next one: " + Arrays.toString(delimiter));
            }
            this.delimiter = delimiter;
            this.currSegment = -1;
        }

        public String toString() {
            return "[segments=" + Arrays.toString(this.delimiter) + ", curr= " + this.currSegment + "]";
        }

        public void nextSegment() {
            if (!this.hasMoreSegments()) {
                throw new NoSuchElementException();
            }
            ++this.currSegment;
        }

        public boolean hasMoreSegments() {
            return this.currSegment < this.delimiter.length - 2;
        }

        public long currentStartMarker() {
            return this.delimiter[this.currSegment];
        }

        public long currentStopMarker() {
            return this.delimiter[this.currSegment + 1];
        }
    }
}

