/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.mg4j.document.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.document.AbstractDocumentSequence;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.DocumentSequence;
import it.unimi.dsi.mg4j.io.SafelyCloseable;
import it.unimi.dsi.mg4j.io.WordReader;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.IOException;
import java.io.Reader;

public abstract class AbstractDocumentCollection
extends AbstractDocumentSequence
implements DocumentCollection,
SafelyCloseable {
    protected void ensureDocumentIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
    }

    public DocumentIterator iterator() throws IOException {
        return new AbstractDocumentIterator(){
            private int nextDocumentToBeReturned = 0;
            private Document last;

            public Document nextDocument() throws IOException {
                if (this.last != null) {
                    this.last.close();
                }
                this.last = this.nextDocumentToBeReturned < AbstractDocumentCollection.this.size() ? AbstractDocumentCollection.this.document(this.nextDocumentToBeReturned++) : null;
                return this.last;
            }
        };
    }

    public String toString() {
        return this.getClass().getName() + "[size: " + this.size() + " factory: " + this.factory() + "]";
    }

    public static void printAllDocuments(DocumentSequence seq) throws IOException {
        Document document;
        DocumentIterator it = seq.iterator();
        int doc = 0;
        while ((document = it.nextDocument()) != null) {
            System.out.println("**** Document # " + doc);
            System.out.println("* Title: " + document.title());
            System.out.println("* URI: " + document.uri());
            System.out.println("****");
            for (int f = 0; f < seq.factory().numberOfFields(); ++f) {
                System.out.println("** Field # " + f + ", " + seq.factory().fieldName(f));
                Object field = document.content(f);
                if (seq.factory().fieldType(f) == DocumentFactory.FieldType.TEXT) {
                    Reader reader = (Reader)field;
                    WordReader wr = document.wordReader(f);
                    wr.setReader(reader);
                    MutableString word = new MutableString();
                    MutableString nonWord = new MutableString();
                    while (wr.next(word, nonWord)) {
                        System.out.println(word.toString() + nonWord.toString());
                    }
                    continue;
                }
                System.out.println(field);
            }
            ++doc;
        }
    }

    public static void main(String[] arg) throws Exception {
        DocumentSequence coll = (DocumentSequence)BinIO.loadObject((CharSequence)arg[0]);
        AbstractDocumentCollection.printAllDocuments(coll);
    }
}

