/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.document.AbstractDocument;
import it.unimi.dsi.mg4j.document.AbstractDocumentCollection;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.NullReader;
import it.unimi.dsi.mg4j.io.WordReader;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.MailDateFormat;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavamailDocumentCollection
extends AbstractDocumentCollection
implements Serializable {
    private static final Logger LOGGER = Fast.getLogger(JavamailDocumentCollection.class);
    public static final Date NO_DATE = new Date(0L);
    private static final long serialVersionUID = 2L;
    private static final Session SESSION = Session.getDefaultInstance((Properties)new Properties());
    private final int numberOfMessages;
    private final JavamailDocumentFactory factory;
    private final String storeUrl;
    private final String folderName;
    private final transient Store store;
    private final transient Folder folder;

    protected JavamailDocumentCollection(String storeUrl, String folderName, JavamailDocumentFactory factory) throws MessagingException {
        this.storeUrl = storeUrl;
        this.folderName = folderName;
        this.factory = factory;
        this.store = SESSION.getStore(new URLName(storeUrl));
        this.store.connect();
        this.folder = this.store.getDefaultFolder().getFolder(folderName);
        this.folder.open(1);
        this.numberOfMessages = this.folder.getMessageCount();
    }

    public JavamailDocumentCollection(String storeUrl, String folderName) throws MessagingException {
        this(storeUrl, folderName, new JavamailDocumentFactory());
    }

    public JavamailDocumentCollection(String storeUrl, String folderName, it.unimi.dsi.mg4j.util.Properties properties) throws MessagingException, ConfigurationException {
        this(storeUrl, folderName, new JavamailDocumentFactory(properties));
    }

    public JavamailDocumentCollection(String storeUrl, String folderName, String[] property) throws MessagingException, ConfigurationException {
        this(storeUrl, folderName, new JavamailDocumentFactory(property));
    }

    public JavamailDocumentCollection(String storeUrl, String folderName, Reference2ObjectMap<Enum<?>, Object> defaultMetadata) throws MessagingException {
        this(storeUrl, folderName, new JavamailDocumentFactory(defaultMetadata));
    }

    @Override
    public JavamailDocumentCollection copy() {
        try {
            return new JavamailDocumentCollection(this.storeUrl, this.folderName, this.factory.copy());
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DocumentFactory factory() {
        return this.factory;
    }

    @Override
    public int size() {
        return this.numberOfMessages;
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.folder.close(false);
            this.store.close();
        }
        catch (MessagingException e) {
            throw new IOException(e.toString());
        }
    }

    private Object readResolve() throws MessagingException, IOException {
        super.close();
        return new JavamailDocumentCollection(this.storeUrl, this.folderName, this.factory);
    }

    @Override
    public Document document(final int index) throws IOException {
        try {
            return new AbstractDocument(){
                final Message message;
                {
                    this.message = JavamailDocumentCollection.this.folder.getMessage(index + 1);
                }

                public CharSequence title() {
                    String subject;
                    try {
                        subject = this.message.getSubject();
                    }
                    catch (MessagingException e) {
                        throw new RuntimeException(e.toString());
                    }
                    if (subject == null) {
                        return (CharSequence)JavamailDocumentCollection.this.factory.resolve(PropertyBasedDocumentFactory.MetadataKeys.TITLE, ((JavamailDocumentCollection)JavamailDocumentCollection.this).factory.defaultMetadata);
                    }
                    return subject;
                }

                public CharSequence uri() {
                    try {
                        return JavamailDocumentCollection.this.folder.getURLName() + "#" + this.message.getMessageNumber();
                    }
                    catch (MessagingException e) {
                        throw new RuntimeException(e);
                    }
                }

                private Reader joinAddresses(Address[] address) {
                    if (address == null) {
                        return NullReader.getInstance();
                    }
                    MutableString s = new MutableString();
                    if (address != null) {
                        for (int i = 0; i < address.length; ++i) {
                            if (i > 0) {
                                s.append(", ");
                            }
                            s.append(address[i]);
                        }
                    }
                    return new FastBufferedReader(s);
                }

                public Object content(int field) throws IOException {
                    JavamailDocumentCollection.this.factory.ensureFieldIndex(field);
                    try {
                        switch (field) {
                            case 0: {
                                Object content = null;
                                try {
                                    content = this.message.getContent();
                                }
                                catch (Exception e) {
                                    LOGGER.warn((Object)("Message " + this.message.getMessageNumber() + " cannot be decoded; content will be empty"), (Throwable)e);
                                }
                                if (content != null && content instanceof String) {
                                    return new StringReader((String)content);
                                }
                                return NullReader.getInstance();
                            }
                            case 1: {
                                return this.message.getSubject() == null ? NullReader.getInstance() : new StringReader(this.message.getSubject());
                            }
                            case 2: {
                                return this.joinAddresses(this.message.getFrom());
                            }
                            case 3: {
                                return this.joinAddresses(this.message.getRecipients(Message.RecipientType.TO));
                            }
                            case 4: {
                                String[] date = this.message.getHeader("date");
                                if (date == null || date.length == 0) {
                                    return NO_DATE;
                                }
                                MailDateFormat mailDateFormat = new MailDateFormat();
                                try {
                                    return mailDateFormat.parse(date[0]);
                                }
                                catch (ParseException e) {
                                    LOGGER.warn((Object)("Error parsing date " + date[0]));
                                    return NO_DATE;
                                }
                            }
                            case 5: {
                                return this.joinAddresses(this.message.getRecipients(Message.RecipientType.CC));
                            }
                            case 6: {
                                return this.joinAddresses(this.message.getRecipients(Message.RecipientType.BCC));
                            }
                            case 7: {
                                return new StringReader(this.message.getContentType());
                            }
                        }
                    }
                    catch (MessagingException e) {
                        if (e instanceof AddressException) {
                            LOGGER.warn((Object)"Error while parsing address", (Throwable)e);
                            return NullReader.getInstance();
                        }
                        throw new IOException(e.toString());
                    }
                    throw new IllegalStateException();
                }

                public WordReader wordReader(int field) {
                    JavamailDocumentCollection.this.factory.ensureFieldIndex(field);
                    return JavamailDocumentCollection.this.factory.wordReader;
                }
            };
        }
        catch (MessagingException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public Reference2ObjectMap<Enum<?>, Object> metadata(int index) {
        this.ensureDocumentIndex(index);
        Reference2ObjectArrayMap metadata = new Reference2ObjectArrayMap(2);
        metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.TITLE, (Object)("Message #" + index));
        metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.URI, (Object)(this.storeUrl + this.folder + "#" + index));
        return metadata;
    }

    @Override
    public InputStream stream(int index) throws IOException {
        this.ensureDocumentIndex(index);
        try {
            return this.folder.getMessage(index + 1).getInputStream();
        }
        catch (MessagingException e) {
            throw new IOException(e.toString());
        }
    }

    public static void main(String[] arg) throws IOException, JSAPException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException, MessagingException, ConfigurationException {
        SimpleJSAP jsap = new SimpleJSAP(JavamailDocumentCollection.class.getName(), "Saves a serialised mbox collection based on a given mbox file.", new Parameter[]{new FlaggedOption("property", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'p', "property", "A 'key=value' specification, or the name of a property file").setAllowMultipleDeclarations(true), new UnflaggedOption("collection", (StringParser)JSAP.STRING_PARSER, true, "The filename for the serialised collection."), new UnflaggedOption("storeUrl", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The javamail store."), new UnflaggedOption("folder", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The folder to be read.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        BinIO.storeObject((Object)new JavamailDocumentCollection(jsapResult.getString("storeUrl"), jsapResult.getString("folder"), jsapResult.getStringArray("property")), (CharSequence)jsapResult.getString("collection"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JavamailDocumentFactory
    extends PropertyBasedDocumentFactory {
        private static final long serialVersionUID = 1L;
        private static final String[] FIELD_NAME = new String[]{"body", "subject", "from", "to", "date", "cc", "bcc", "content-type"};
        private static final DocumentFactory.FieldType[] FIELD_TYPE = new DocumentFactory.FieldType[]{DocumentFactory.FieldType.TEXT, DocumentFactory.FieldType.TEXT, DocumentFactory.FieldType.TEXT, DocumentFactory.FieldType.TEXT, DocumentFactory.FieldType.DATE, DocumentFactory.FieldType.TEXT, DocumentFactory.FieldType.TEXT, DocumentFactory.FieldType.TEXT};
        private static final Object2IntOpenHashMap<String> FIELD2INDEX = new Object2IntOpenHashMap(FIELD_NAME.length, 0.5f);
        private WordReader wordReader = new FastBufferedReader();

        @Override
        protected boolean parseProperty(String key, String[] values, Reference2ObjectMap<Enum<?>, Object> metadata) throws ConfigurationException {
            if (JavamailDocumentFactory.sameKey(PropertyBasedDocumentFactory.MetadataKeys.ENCODING, key)) {
                metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.ENCODING, (Object)Charset.forName(JavamailDocumentFactory.ensureJustOne(key, values)).toString());
                return true;
            }
            return super.parseProperty(key, values, metadata);
        }

        public JavamailDocumentFactory() {
            this.init();
        }

        public JavamailDocumentFactory(it.unimi.dsi.mg4j.util.Properties properties) throws ConfigurationException {
            super(properties);
            this.init();
        }

        public JavamailDocumentFactory(Reference2ObjectMap<Enum<?>, Object> defaultMetadata) {
            super(defaultMetadata);
            this.init();
        }

        public JavamailDocumentFactory(String[] property) throws ConfigurationException {
            super(property);
            this.init();
        }

        private void init() {
            this.wordReader = new FastBufferedReader();
        }

        @Override
        public JavamailDocumentFactory copy() {
            return new JavamailDocumentFactory(this.defaultMetadata);
        }

        @Override
        public int numberOfFields() {
            return FIELD_NAME.length;
        }

        @Override
        public String fieldName(int field) {
            this.ensureFieldIndex(field);
            return FIELD_NAME[field];
        }

        @Override
        public DocumentFactory.FieldType fieldType(int field) {
            this.ensureFieldIndex(field);
            return FIELD_TYPE[field];
        }

        @Override
        public int fieldIndex(String fieldName) {
            return FIELD2INDEX.getInt((Object)fieldName);
        }

        @Override
        public Document getDocument(InputStream rawContent, Reference2ObjectMap<Enum<?>, Object> metadata) {
            throw new UnsupportedOperationException();
        }

        static {
            FIELD2INDEX.defaultReturnValue(-1);
            for (int i = 0; i < FIELD_NAME.length; ++i) {
                FIELD2INDEX.put((Object)FIELD_NAME[i], i);
            }
        }
    }
}

