/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.core.TreeUnmarshaller;
import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.path.Path;
import com.thoughtworks.xstream.io.path.PathTracker;
import com.thoughtworks.xstream.io.path.PathTrackingReader;
import java.util.HashMap;
import java.util.Map;

public class ReferenceByXPathUnmarshaller
extends TreeUnmarshaller {
    private Map values = new HashMap();
    private FastStack parentPathStack = new FastStack(16);
    private PathTracker pathTracker = new PathTracker();

    public ReferenceByXPathUnmarshaller(Object root, HierarchicalStreamReader reader, ConverterLookup converterLookup, ClassMapper classMapper) {
        super(root, reader, converterLookup, classMapper);
        this.reader = new PathTrackingReader(reader, this.pathTracker);
    }

    public Object convertAnother(Object parent, Class type) {
        Object parentPath;
        if (this.parentPathStack.size() > 0 && !this.values.containsKey(parentPath = this.parentPathStack.peek())) {
            this.values.put(parentPath, parent);
        }
        String relativePathOfReference = this.reader.getAttribute("reference");
        Path currentPath = this.pathTracker.getPath();
        if (relativePathOfReference != null) {
            return this.values.get(currentPath.apply(new Path(relativePathOfReference)));
        }
        this.parentPathStack.push(currentPath);
        Object result = super.convertAnother(parent, type);
        this.values.put(currentPath, result);
        this.parentPathStack.popSilently();
        return result;
    }
}

