/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.visualization;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.math.stat.clustering.Clusterable;

class KMeansRow
implements Clusterable<KMeansRow>,
Serializable {
    private static final long serialVersionUID = -323598431692368500L;
    private final String id;
    private final float[] point;

    public KMeansRow(String id, float[] point) {
        this.point = point;
        this.id = id;
    }

    public float[] getPoint() {
        return this.point;
    }

    public double distanceFrom(KMeansRow p) {
        double sumSquares = 0.0;
        float[] otherPoint = p.getPoint();
        for (int i = 0; i < this.point.length; ++i) {
            sumSquares += Math.pow(this.point[i] - otherPoint[i], 2.0);
        }
        return Math.sqrt(sumSquares);
    }

    public KMeansRow centroidOf(Collection<KMeansRow> points) {
        float[] centroid = new float[this.getPoint().length];
        for (KMeansRow p : points) {
            for (int i = 0; i < centroid.length; ++i) {
                int n = i;
                centroid[n] = centroid[n] + p.getPoint()[i];
            }
        }
        int i = 0;
        while (i < centroid.length) {
            int n = i++;
            centroid[n] = centroid[n] / (float)points.size();
        }
        return new KMeansRow(this.id, centroid);
    }

    public boolean equals(Object other) {
        if (!(other instanceof KMeansRow)) {
            return false;
        }
        float[] otherPoint = ((KMeansRow)other).getPoint();
        if (this.point.length != otherPoint.length) {
            return false;
        }
        for (int i = 0; i < this.point.length; ++i) {
            if (this.point[i] == otherPoint[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        float[] arr$ = this.point;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Float i = Float.valueOf(arr$[i$]);
            hashCode += i.hashCode() * 13 + 7;
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder(this.id);
        for (float value : this.getPoint()) {
            buff.append("\t").append(value);
        }
        return buff.toString();
    }

    public String getId() {
        return this.id;
    }
}

