/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class GaussianSmooth
extends WigMathTool {
    private static final Logger log = Logger.getLogger(GaussianSmooth.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    @Parameter(names={"-s", "--stdev"}, description="Standard deviation of Gaussian (bp)")
    public int stdev = 20;
    float[] filter;

    @Override
    public void setup() {
        int i;
        this.inputs.add(this.inputFile);
        this.filter = new float[6 * this.stdev + 1];
        float sum = 0.0f;
        for (i = 0; i < this.filter.length; ++i) {
            float value;
            float x = i - 3 * this.stdev;
            this.filter[i] = value = (float)Math.exp(-(x * x) / (float)(2 * this.stdev * this.stdev));
            sum += value;
        }
        i = 0;
        while (i < this.filter.length) {
            int n = i++;
            this.filter[n] = this.filter[n] / sum;
        }
    }

    @Override
    public float[] compute(String chr, int start, int stop) throws IOException, WigFileException {
        log.debug((Object)("Smoothing chunk " + chr + ":" + start + "-" + stop));
        int paddedStart = Math.max(start - 3 * this.stdev, this.inputFile.getChrStart(chr));
        int paddedStop = Math.min(stop + 3 * this.stdev, this.inputFile.getChrStop(chr));
        Iterator result = this.inputFile.query(chr, paddedStart, paddedStop);
        float[] data = WigFile.flattenData((Iterator)result, (int)(start - 3 * this.stdev), (int)(stop + 3 * this.stdev));
        float[] smoothed = new float[stop - start + 1];
        for (int i = 0; i < smoothed.length; ++i) {
            for (int j = 0; j < this.filter.length; ++j) {
                int n = i;
                smoothed[n] = smoothed[n] + data[i + j] * this.filter[j];
            }
        }
        return smoothed;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new GaussianSmooth().instanceMain(args);
    }
}

