/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.formimpl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.launch4j.FileChooserFilter;
import net.sf.launch4j.binding.Bindings;
import net.sf.launch4j.binding.Validator;
import net.sf.launch4j.config.ClassPath;
import net.sf.launch4j.form.ClassPathForm;
import net.sf.launch4j.formimpl.AbstractAcceptListener;
import net.sf.launch4j.formimpl.MainFrame;
import net.sf.launch4j.formimpl.Messages;

public class ClassPathFormImpl
extends ClassPathForm {
    private final JFileChooser _fileChooser;
    private final FileChooserFilter _filter = new FileChooserFilter("Executable jar", ".jar");

    public ClassPathFormImpl(Bindings bindings, JFileChooser fc) {
        bindings.addOptComponent("classPath", ClassPath.class, this._classpathCheck).add("classPath.mainClass", this._mainclassField).add("classPath.paths", this._classpathList);
        this._fileChooser = fc;
        ClasspathCheckListener cpl = new ClasspathCheckListener();
        this._classpathCheck.addChangeListener(cpl);
        cpl.stateChanged(null);
        this._classpathList.setModel(new DefaultListModel());
        this._classpathList.setSelectionMode(2);
        this._classpathList.addListSelectionListener(new ClasspathSelectionListener());
        this._newClasspathButton.addActionListener(new NewClasspathListener());
        this._acceptClasspathButton.addActionListener(new AcceptClasspathListener(this._classpathField));
        this._removeClasspathButton.addActionListener(new RemoveClasspathListener());
        this._importClasspathButton.addActionListener(new ImportClasspathListener());
        this._classpathUpButton.addActionListener(new MoveUpListener());
        this._classpathDownButton.addActionListener(new MoveDownListener());
    }

    private class ImportClasspathListener
    implements ActionListener {
        private ImportClasspathListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ClassPathFormImpl.this._fileChooser.setFileFilter(ClassPathFormImpl.this._filter);
                ClassPathFormImpl.this._fileChooser.setSelectedFile(new File(""));
                if (ClassPathFormImpl.this._fileChooser.showOpenDialog(MainFrame.getInstance()) == 0) {
                    JarFile jar = new JarFile(ClassPathFormImpl.this._fileChooser.getSelectedFile());
                    if (jar.getManifest() == null) {
                        jar.close();
                        MainFrame.getInstance().info(Messages.getString("noManifest"));
                        return;
                    }
                    Attributes attr = jar.getManifest().getMainAttributes();
                    String mainClass = attr.getValue("Main-Class");
                    String classPath = attr.getValue("Class-Path");
                    jar.close();
                    ClassPathFormImpl.this._mainclassField.setText(mainClass != null ? mainClass : "");
                    DefaultListModel<String> model = new DefaultListModel<String>();
                    if (classPath != null) {
                        String[] paths = classPath.split(" ");
                        for (int i = 0; i < paths.length; ++i) {
                            model.addElement(paths[i]);
                        }
                    }
                    ClassPathFormImpl.this._classpathList.setModel(model);
                }
            }
            catch (IOException ex) {
                MainFrame.getInstance().warn(ex.getMessage());
            }
        }
    }

    private class MoveDownListener
    implements ActionListener {
        private MoveDownListener() {
        }

        public void actionPerformed(ActionEvent e) {
            DefaultListModel model = (DefaultListModel)ClassPathFormImpl.this._classpathList.getModel();
            int x = ClassPathFormImpl.this._classpathList.getSelectedIndex();
            if (x == -1 || x >= model.getSize() - 1) {
                return;
            }
            Object o = model.get(x + 1);
            model.set(x + 1, model.get(x));
            model.set(x, o);
            ClassPathFormImpl.this._classpathList.setSelectedIndex(x + 1);
        }
    }

    private class MoveUpListener
    implements ActionListener {
        private MoveUpListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int x = ClassPathFormImpl.this._classpathList.getSelectedIndex();
            if (x < 1) {
                return;
            }
            DefaultListModel model = (DefaultListModel)ClassPathFormImpl.this._classpathList.getModel();
            Object o = model.get(x - 1);
            model.set(x - 1, model.get(x));
            model.set(x, o);
            ClassPathFormImpl.this._classpathList.setSelectedIndex(x - 1);
        }
    }

    private class RemoveClasspathListener
    implements ActionListener {
        private RemoveClasspathListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ClassPathFormImpl.this._classpathList.isSelectionEmpty() || !MainFrame.getInstance().confirm(Messages.getString("confirmClassPathRemoval"))) {
                return;
            }
            DefaultListModel model = (DefaultListModel)ClassPathFormImpl.this._classpathList.getModel();
            while (!ClassPathFormImpl.this._classpathList.isSelectionEmpty()) {
                model.remove(ClassPathFormImpl.this._classpathList.getSelectedIndex());
            }
        }
    }

    private class ClasspathSelectionListener
    implements ListSelectionListener {
        private ClasspathSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (ClassPathFormImpl.this._classpathList.isSelectionEmpty()) {
                ClassPathFormImpl.this._classpathField.setText("");
            } else {
                ClassPathFormImpl.this._classpathField.setText((String)ClassPathFormImpl.this._classpathList.getSelectedValue());
            }
            ClassPathFormImpl.this._classpathField.requestFocusInWindow();
        }
    }

    private class AcceptClasspathListener
    extends AbstractAcceptListener {
        public AcceptClasspathListener(JTextField f) {
            super(f, true);
        }

        public void actionPerformed(ActionEvent e) {
            String cp = this.getText();
            if (Validator.isEmpty(cp)) {
                this.signalViolation(Messages.getString("specifyClassPath"));
                return;
            }
            DefaultListModel model = (DefaultListModel)ClassPathFormImpl.this._classpathList.getModel();
            if (ClassPathFormImpl.this._classpathList.isSelectionEmpty()) {
                model.addElement(cp);
                this.clear();
            } else {
                model.setElementAt(cp, ClassPathFormImpl.this._classpathList.getSelectedIndex());
            }
        }
    }

    private class NewClasspathListener
    implements ActionListener {
        private NewClasspathListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ClassPathFormImpl.this._classpathList.clearSelection();
            ClassPathFormImpl.this._classpathField.setText("");
            ClassPathFormImpl.this._classpathField.requestFocusInWindow();
        }
    }

    private class ClasspathCheckListener
    implements ChangeListener {
        private ClasspathCheckListener() {
        }

        public void stateChanged(ChangeEvent e) {
            boolean on = ClassPathFormImpl.this._classpathCheck.isSelected();
            ClassPathFormImpl.this._importClasspathButton.setEnabled(on);
            ClassPathFormImpl.this._classpathUpButton.setEnabled(on);
            ClassPathFormImpl.this._classpathDownButton.setEnabled(on);
            ClassPathFormImpl.this._classpathField.setEnabled(on);
            ClassPathFormImpl.this._newClasspathButton.setEnabled(on);
            ClassPathFormImpl.this._acceptClasspathButton.setEnabled(on);
            ClassPathFormImpl.this._removeClasspathButton.setEnabled(on);
        }
    }
}

