/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.math3.stat.Frequency;
import org.apache.log4j.Logger;

public class IntervalLengthDistribution
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(IntervalLengthDistribution.class);
    @Parameter(names={"-i", "--input"}, description="Interval file", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-f", "--freq"}, description="Output frequencies rather than counts")
    public boolean outputFreq = false;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        log.debug((Object)"Generating histogram of interval lengths");
        Frequency freq = new Frequency();
        int min = Integer.MAX_VALUE;
        int max = -1;
        try (IntervalFileReader reader = IntervalFileReader.autodetect((Path)this.inputFile);){
            for (Interval i : reader) {
                int L = i.length();
                freq.addValue(L);
                if (L < min) {
                    min = L;
                }
                if (L <= max) continue;
                max = L;
            }
        }
        log.debug((Object)"Writing histogram output");
        var5_5 = null;
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]));){
            for (int i = min; i <= max; ++i) {
                if (this.outputFreq) {
                    writer.println(i + "\t" + freq.getPct(i));
                    continue;
                }
                writer.println(i + "\t" + freq.getCount(i));
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    public static void main(String[] args) {
        new IntervalLengthDistribution().instanceMain(args);
    }
}

