/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.Interval;
import edu.unc.genomics.IntervalFactory;
import edu.unc.genomics.io.IntervalFileFormatException;
import edu.unc.genomics.io.IntervalFileReader;
import edu.unc.genomics.io.StringIntervalIterator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;
import net.sf.samtools.TabixReader;
import org.apache.log4j.Logger;

public class TabixFileReader<T extends Interval>
extends IntervalFileReader<T> {
    private static final Logger log = Logger.getLogger(TabixFileReader.class);
    private TabixReader reader;
    private IntervalFactory<T> factory;
    private int count = 0;

    protected TabixFileReader(Path p, IntervalFactory<T> factory) throws IOException {
        super(p);
        this.factory = factory;
        log.debug((Object)("Opening Tabix file reader " + p));
        this.reader = new TabixReader(p);
    }

    @Override
    public Iterator<T> iterator() {
        return new StringIntervalIterator<T>(this.reader.iterator(), this.factory);
    }

    @Override
    public void close() throws IOException {
        log.debug((Object)("Closing Tabix file reader " + this.p));
    }

    @Override
    public Iterator<T> query(String chr, int start, int stop) {
        return new StringIntervalIterator<T>(this.reader.query(chr, start, stop), this.factory);
    }

    @Override
    public int count() throws IntervalFileFormatException {
        if (this.count == 0) {
            try {
                TabixReader tmpReader = new TabixReader(this.p);
                StringIntervalIterator<T> tmpIter = new StringIntervalIterator<T>(tmpReader.iterator(), this.factory);
                while (tmpIter.hasNext()) {
                    tmpIter.next();
                    ++this.count;
                }
            }
            catch (IOException e) {
                log.error((Object)("Error counting entries in Tabix file " + this.p));
                e.printStackTrace();
                throw new IntervalFileFormatException("Error counting entries in Tabix file " + this.p);
            }
        }
        return this.count;
    }

    @Override
    public Set<String> chromosomes() {
        return this.reader.chromosomes();
    }
}

