/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.FastMath;

public class Sigmoid
implements DifferentiableUnivariateFunction {
    private final double lo;
    private final double hi;

    public Sigmoid() {
        this(0.0, 1.0);
    }

    public Sigmoid(double lo, double hi) {
        this.lo = lo;
        this.hi = hi;
    }

    public UnivariateFunction derivative() {
        return new UnivariateFunction(){

            public double value(double x) {
                double exp = FastMath.exp(-x);
                if (Double.isInfinite(exp)) {
                    return 0.0;
                }
                double exp1 = 1.0 + exp;
                return (Sigmoid.this.hi - Sigmoid.this.lo) * exp / (exp1 * exp1);
            }
        };
    }

    public double value(double x) {
        return Sigmoid.value(x, this.lo, this.hi);
    }

    private static double value(double x, double lo, double hi) {
        return lo + (hi - lo) / (1.0 + FastMath.exp(-x));
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        public double value(double x, double ... param) {
            this.validateParameters(param);
            return Sigmoid.value(x, param[0], param[1]);
        }

        public double[] gradient(double x, double ... param) {
            this.validateParameters(param);
            double invExp1 = 1.0 / (1.0 + FastMath.exp(-x));
            return new double[]{1.0 - invExp1, invExp1};
        }

        private void validateParameters(double[] param) {
            if (param == null) {
                throw new NullArgumentException();
            }
            if (param.length != 2) {
                throw new DimensionMismatchException(param.length, 2);
            }
        }
    }
}

