/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.dna;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.FastaEntry;
import edu.unc.genomics.io.FastaFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.log4j.Logger;
import org.genomeview.dnaproperties.DNAProperty;

public class DNAPropertyCalculator
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(DNAPropertyCalculator.class);
    @Parameter(names={"-i", "--input"}, description="Input file (FASTA)", required=true)
    public FastaFile inputFile;
    @Parameter(names={"-p", "--property"}, description="DNA property to calculate", required=true)
    public String propertyName;
    @Parameter(names={"-n", "--normalize"}, description="Output normalized values")
    public boolean normalize = true;
    @Parameter(names={"-o", "--output"}, description="Output file (Wiggle)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        DNAProperty property = DNAProperty.create((String)this.propertyName);
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write("track type=wiggle_0");
            writer.newLine();
            for (FastaEntry f : this.inputFile) {
                log.debug((Object)("Processing FASTA entry " + f.getId()));
                double[] values = this.normalize ? property.normalizedProfile(f.getSeq()) : property.profile(f.getSeq());
                writer.write("fixedStep chrom=" + f.getId() + " start=1 step=1 span=1");
                writer.newLine();
                for (double value : values) {
                    writer.write(Double.toString(value));
                    writer.newLine();
                }
            }
        }
    }

    public static void main(String[] args) {
        new DNAPropertyCalculator().instanceMain(args);
    }
}

