/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.Interval;
import edu.unc.genomics.IntervalFactory;
import edu.unc.genomics.io.BufferedLineReader;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.StringIntervalIterator;
import edu.unc.genomics.io.TabixFile;
import edu.unc.genomics.util.FileUtils;
import edu.unc.genomics.util.Tabix;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import net.sf.samtools.TabixWriter;
import org.apache.log4j.Logger;

public abstract class TextIntervalFile<T extends Interval>
extends IntervalFile<T> {
    private static final Logger log = Logger.getLogger(TextIntervalFile.class);
    protected IntervalFactory<T> factory;
    private Set<String> chromosomes;
    private int count = 0;
    private final BufferedReader reader;
    private final Iterator<T> iter;
    private Path bgzip;
    private Path index;
    private TabixFile<T> tabixFile;

    protected TextIntervalFile(Path p, IntervalFactory<T> factory) throws IOException {
        super(p);
        this.factory = factory;
        this.reader = Files.newBufferedReader(p, Charset.defaultCharset());
        BufferedLineReader lineReader = new BufferedLineReader(this.reader);
        this.iter = new StringIntervalIterator<T>(lineReader.iterator(), factory);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public Set<String> chromosomes() {
        if (this.chromosomes == null) {
            if (this.tabixFile == null) {
                this.convertToTabix();
            }
            this.chromosomes = this.tabixFile.chromosomes();
        }
        return this.chromosomes;
    }

    @Override
    public int count() {
        if (this.count == 0) {
            if (this.tabixFile == null) {
                this.convertToTabix();
            }
            this.count = this.tabixFile.count();
        }
        return this.count;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iter;
    }

    @Override
    public Iterator<T> query(String chr, int start, int stop) {
        if (this.tabixFile == null) {
            this.convertToTabix();
        }
        return this.tabixFile.query(chr, start, stop);
    }

    private void convertToTabix() {
        try {
            Path filtered = Files.createTempFile(this.p.getFileName().toString(), ".filtered", new FileAttribute[0]);
            filtered.toFile().deleteOnExit();
            log.debug((Object)("Filtering interval file to temp: " + filtered));
            try (BufferedWriter writer = Files.newBufferedWriter(filtered, Charset.defaultCharset(), new OpenOption[0]);
                 BufferedReader reader = Files.newBufferedReader(this.p, Charset.defaultCharset());){
                String line;
                while ((line = reader.readLine()) != null) {
                    T interval = this.factory.parse(line);
                    if (interval == null) continue;
                    writer.write(line);
                    writer.newLine();
                }
            }
            Path sorted = Files.createTempFile(this.p.getFileName().toString(), ".sorted", new FileAttribute[0]);
            log.debug((Object)("Sorting interval file to temp: " + sorted));
            sorted.toFile().deleteOnExit();
            FileUtils.sort(filtered, sorted, this.getTabixComparator());
            this.bgzip = this.p.resolveSibling(sorted.getFileName() + ".gz");
            this.bgzip.toFile().deleteOnExit();
            Tabix.bgzip(sorted, this.bgzip);
            this.index = Tabix.index(this.bgzip, this.factory.tabixConf());
            this.index.toFile().deleteOnExit();
        }
        catch (IOException e3) {
            log.error((Object)"Error sorting and compressing interval file");
            throw new RuntimeException("Error sorting and compressing interval file");
        }
        catch (TabixWriter.TabixException e1) {
            log.error((Object)"Error indexing with Tabix");
            e1.printStackTrace();
            throw new RuntimeException("Error indexing Tabix file");
        }
        try {
            this.tabixFile = new TabixFile<T>(this.bgzip, this.factory);
        }
        catch (IOException e) {
            log.error((Object)"Error initializing Tabix file");
            e.printStackTrace();
            throw new RuntimeException("Error initializing Tabix file");
        }
    }

    protected Comparator<String> getTabixComparator() {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                Integer start2;
                String[] entry2;
                String chr2;
                TabixWriter.Conf conf = TextIntervalFile.this.factory.tabixConf();
                String[] entry1 = s1.split("\t");
                String chr1 = entry1[conf.chrColumn - 1];
                int c1 = chr1.compareTo(chr2 = (entry2 = s2.split("\t"))[conf.chrColumn - 1]);
                if (c1 != 0) {
                    return c1;
                }
                Integer start1 = Integer.valueOf(entry1[conf.startColumn - 1]);
                int c2 = start1.compareTo(start2 = Integer.valueOf(entry2[conf.startColumn - 1]));
                if (c2 != 0) {
                    return c2;
                }
                Integer stop1 = Integer.valueOf(entry1[conf.endColumn - 1]);
                Integer stop2 = Integer.valueOf(entry2[conf.endColumn - 1]);
                int c3 = stop1.compareTo(stop2);
                return c3;
            }
        };
        return comparator;
    }
}

