/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.log4j.Logger;

public class FindOutlierRegions
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(FindOutlierRegions.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    @Parameter(names={"-w", "--window"}, description="Window size", required=true)
    public int windowSize;
    @Parameter(names={"-t", "--threshold"}, description="Threshold (fold x mean)")
    public float fold = 3.0f;
    @Parameter(names={"-o", "--output"}, description="Output file (bed)", required=true)
    public Path outputFile;
    double threshold;
    DescriptiveStatistics stats;

    @Override
    public void run() throws IOException {
        this.threshold = (double)this.fold * this.inputFile.mean();
        this.stats = new DescriptiveStatistics();
        this.stats.setWindowSize(this.windowSize);
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            for (String chr : this.inputFile.chromosomes()) {
                int start = this.inputFile.getChrStart(chr);
                int stop = this.inputFile.getChrStop(chr);
                log.debug((Object)("Processing chromosome " + chr + " region " + start + "-" + stop));
                int bp = start;
                Integer outlierStart = null;
                this.stats.clear();
                while (bp < stop) {
                    int chunkStart = bp;
                    int chunkStop = Math.min(bp + 300000 - 1, stop);
                    log.debug((Object)("Processing chunk " + chr + ":" + chunkStart + "-" + chunkStop));
                    try {
                        Iterator result = this.inputFile.query(chr, chunkStart, chunkStop);
                        float[] data = WigFile.flattenData((Iterator)result, (int)chunkStart, (int)chunkStop);
                        for (int i = 0; i < data.length; ++i) {
                            this.stats.addValue((double)data[i]);
                            if (outlierStart == null) {
                                if (!(this.stats.getMean() > this.threshold)) continue;
                                outlierStart = bp + i - this.windowSize;
                                continue;
                            }
                            if (!(this.stats.getMean() < this.threshold)) continue;
                            int outlierStop = bp + i;
                            writer.write(chr + "\t" + outlierStart + "\t" + outlierStop);
                            writer.newLine();
                            outlierStart = null;
                        }
                    }
                    catch (WigFileException e) {
                        log.fatal((Object)("Wig file error while processing chunk " + chr + " region " + start + "-" + stop));
                        e.printStackTrace();
                        throw new RuntimeException("Wig file error while processing chunk " + chr + " region " + start + "-" + stop);
                    }
                    bp = chunkStop + 1;
                }
            }
        }
        this.inputFile.close();
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new FindOutlierRegions().instanceMain(args);
    }
}

