/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.WigItem;

public class Divide
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Divide.class);
    @Parameter(names={"-n", "--numerator"}, description="Dividend / Numerator (file 1)", required=true)
    public WigFile dividendFile;
    @Parameter(names={"-d", "--denominator"}, description="Divisor / Denominator (file 2)", required=true)
    public WigFile divisorFile;

    @Override
    public void setup() {
        this.inputs.add(this.dividendFile);
        this.inputs.add(this.divisorFile);
        log.debug((Object)("Initialized " + this.inputs.size() + " input files"));
    }

    @Override
    public float[] compute(String chr, int start, int stop) throws IOException, WigFileException {
        Iterator dividendData = this.dividendFile.query(chr, start, stop);
        Iterator divisorData = this.divisorFile.query(chr, start, stop);
        float[] result = WigFile.flattenData((Iterator)dividendData, (int)start, (int)stop);
        while (divisorData.hasNext()) {
            WigItem item = (WigItem)divisorData.next();
            for (int i = item.getStartBase(); i <= item.getEndBase(); ++i) {
                if (i - start < 0 || i - start >= result.length) continue;
                if (item.getWigValue() != 0.0f) {
                    int n = i - start;
                    result[n] = result[n] / item.getWigValue();
                    continue;
                }
                result[i - start] = Float.NaN;
            }
        }
        return result;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new Divide().instanceMain(args);
    }
}

