/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.utils.WigStatistic;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Downsample
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(Downsample.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    @Parameter(names={"-w", "--window"}, description="Window size (bp)")
    public int windowSize = 100;
    @Parameter(names={"-m", "--metric"}, description="Downsampling metric (mean/min/max)")
    public String metric = "mean";
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        WigStatistic dsm = WigStatistic.fromName(this.metric);
        if (dsm == null) {
            log.error((Object)("Unknown downsampling metric: " + this.metric));
            throw new CommandLineToolException("Unknown downsampling metric: " + this.metric + ". Options are mean, min, max");
        }
        log.debug((Object)("Using downsampling metric: " + this.metric));
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write("track type=wiggle_0 name='Downsampled " + this.inputFile.getPath().getFileName() + "' description='Downsampled " + this.inputFile.getPath().getFileName() + "'");
            writer.newLine();
            for (String chr : this.inputFile.chromosomes()) {
                log.debug((Object)("Processing chromosome " + chr));
                int start = this.inputFile.getChrStart(chr);
                int stop = this.inputFile.getChrStop(chr);
                writer.write("fixedStep chrom=" + chr + " start=" + start + " step=" + this.windowSize + " span=" + this.windowSize);
                writer.newLine();
                int bp = start;
                while (bp < stop) {
                    int chunkStart = bp;
                    int chunkStop = Math.min(bp + this.windowSize - 1, stop);
                    try {
                        Iterator result = this.inputFile.query(chr, chunkStart, chunkStop);
                        float value = Float.NaN;
                        switch (dsm) {
                            case MEAN: {
                                value = WigFile.mean((Iterator)result, (int)chunkStart, (int)chunkStop);
                                break;
                            }
                            case MIN: {
                                value = WigFile.min((Iterator)result, (int)chunkStart, (int)chunkStop);
                                break;
                            }
                            case MAX: {
                                value = WigFile.max((Iterator)result, (int)chunkStart, (int)chunkStop);
                            }
                        }
                        writer.write(String.valueOf(value));
                        writer.newLine();
                    }
                    catch (WigFileException e) {
                        log.error((Object)("Error querying Wig file for data from interval " + chr + ":" + chunkStart + "-" + chunkStop));
                        e.printStackTrace();
                        throw new CommandLineToolException("Error querying Wig file for data from interval " + chr + ":" + chunkStart + "-" + chunkStop);
                    }
                    bp = chunkStop + 1;
                }
            }
        }
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new Downsample().instanceMain(args);
    }
}

