/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dst;

import edu.emory.mathcs.jtransforms.dct.FloatDCT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class FloatDST_1D {
    private int n;
    private FloatDCT_1D dct;

    public FloatDST_1D(int n) {
        this.n = n;
        this.dct = new FloatDCT_1D(n);
    }

    public void forward(float[] fArray, boolean bl) {
        this.forward(fArray, 0, bl);
    }

    public void forward(final float[] fArray, final int n, boolean bl) {
        int n2;
        if (this.n == 1) {
            return;
        }
        int n3 = this.n / 2;
        int n4 = 1 + n;
        int n5 = n + this.n;
        for (n2 = n4; n2 < n5; n2 += 2) {
            fArray[n2] = -fArray[n2];
        }
        this.dct.forward(fArray, n, bl);
        n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n3 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            n2 = 2;
            int n6 = n3 / n2;
            Future[] futureArray = new Future[n2];
            for (int i = 0; i < n2; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n2 - 1 ? n3 : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = n + FloatDST_1D.this.n - 1;
                        for (int i = n7; i < n8; ++i) {
                            int n2 = n + i;
                            float f = fArray[n2];
                            int n3 = n4 - i;
                            fArray[n2] = fArray[n3];
                            fArray[n3] = f;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n + this.n - 1;
            for (int i = 0; i < n3; ++i) {
                int n10 = n + i;
                float f = fArray[n10];
                int n11 = n9 - i;
                fArray[n10] = fArray[n11];
                fArray[n11] = f;
            }
        }
    }

    public void inverse(float[] fArray, boolean bl) {
        this.inverse(fArray, 0, bl);
    }

    public void inverse(final float[] fArray, final int n, boolean bl) {
        int n2;
        int n3;
        if (this.n == 1) {
            return;
        }
        int n4 = this.n / 2;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && n4 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            n5 = 2;
            n3 = n4 / n5;
            Future[] futureArray = new Future[n5];
            for (n2 = 0; n2 < n5; ++n2) {
                final int n6 = n2 * n3;
                final int n7 = n2 == n5 - 1 ? n4 : n6 + n3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = n + FloatDST_1D.this.n - 1;
                        for (int i = n6; i < n7; ++i) {
                            int n2 = n + i;
                            float f = fArray[n2];
                            int n3 = n4 - i;
                            fArray[n2] = fArray[n3];
                            fArray[n3] = f;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            n3 = n + this.n - 1;
            for (int i = 0; i < n4; ++i) {
                float f = fArray[n + i];
                fArray[n + i] = fArray[n3 - i];
                fArray[n3 - i] = f;
            }
        }
        this.dct.inverse(fArray, n, bl);
        n3 = 1 + n;
        int n8 = n + this.n;
        for (n2 = n3; n2 < n8; n2 += 2) {
            fArray[n2] = -fArray[n2];
        }
    }
}

